import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#description ComputeDisk#description}
    */
    readonly description?: string;
    /**
    * The image from which to initialize this disk. This can be
  one of: the image's 'self_link', 'projects/{project}/global/images/{image}',
  'projects/{project}/global/images/family/{family}', 'global/images/{image}',
  'global/images/family/{family}', 'family/{family}', '{project}/{family}',
  '{project}/{image}', '{family}', or '{image}'. If referred by family, the
  images names must include the family name. If they don't, use the
  [google_compute_image data source](/docs/providers/google/d/compute_image.html).
  For instance, the image 'centos-6-v20180104' includes its family name 'centos-6'.
  These images can be referred by family name here.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#image ComputeDisk#image}
    */
    readonly image?: string;
    /**
    * Labels to apply to this disk.  A list of key->value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#labels ComputeDisk#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#name ComputeDisk#name}
    */
    readonly name: string;
    /**
    * Physical block size of the persistent disk, in bytes. If not present
  in a request, a default value is used. Currently supported sizes
  are 4096 and 16384, other sizes may be added in the future.
  If an unsupported value is requested, the error message will list
  the supported values for the caller's project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#physical_block_size_bytes ComputeDisk#physical_block_size_bytes}
    */
    readonly physicalBlockSizeBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#project ComputeDisk#project}
    */
    readonly project?: string;
    /**
    * Indicates how many IOPS must be provisioned for the disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#provisioned_iops ComputeDisk#provisioned_iops}
    */
    readonly provisionedIops?: number;
    /**
    * Size of the persistent disk, specified in GB. You can specify this
  field when creating a persistent disk using the 'image' or
  'snapshot' parameter, or specify it alone to create an empty
  persistent disk.
  
  If you specify this field along with 'image' or 'snapshot',
  the value must not be less than the size of the image
  or the size of the snapshot.
  
  ~>**NOTE** If you change the size, Terraform updates the disk size
  if upsizing is detected but recreates the disk if downsizing is requested.
  You can add 'lifecycle.prevent_destroy' in the config to prevent destroying
  and recreating.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#size ComputeDisk#size}
    */
    readonly size?: number;
    /**
    * The source snapshot used to create this disk. You can provide this as
  a partial or full URL to the resource. If the snapshot is in another
  project than this disk, you must supply a full URL. For example, the
  following are valid values:
  
  * 'https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot'
  * 'projects/project/global/snapshots/snapshot'
  * 'global/snapshots/snapshot'
  * 'snapshot'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#snapshot ComputeDisk#snapshot}
    */
    readonly snapshot?: string;
    /**
    * URL of the disk type resource describing which disk type to use to
  create the disk. Provide this when creating the disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#type ComputeDisk#type}
    */
    readonly type?: string;
    /**
    * A reference to the zone where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#zone ComputeDisk#zone}
    */
    readonly zone?: string;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#disk_encryption_key ComputeDisk#disk_encryption_key}
    */
    readonly diskEncryptionKey?: ComputeDiskDiskEncryptionKey;
    /**
    * source_image_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#source_image_encryption_key ComputeDisk#source_image_encryption_key}
    */
    readonly sourceImageEncryptionKey?: ComputeDiskSourceImageEncryptionKey;
    /**
    * source_snapshot_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#source_snapshot_encryption_key ComputeDisk#source_snapshot_encryption_key}
    */
    readonly sourceSnapshotEncryptionKey?: ComputeDiskSourceSnapshotEncryptionKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#timeouts ComputeDisk#timeouts}
    */
    readonly timeouts?: ComputeDiskTimeouts;
}
export interface ComputeDiskDiskEncryptionKey {
    /**
    * The self link of the encryption key used to encrypt the disk. Also called KmsKeyName
  in the cloud console. Your project's Compute Engine System service account
  ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
  'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
  See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#kms_key_self_link ComputeDisk#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
  If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#kms_key_service_account ComputeDisk#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
  RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#raw_key ComputeDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function computeDiskDiskEncryptionKeyToTerraform(struct?: ComputeDiskDiskEncryptionKeyOutputReference | ComputeDiskDiskEncryptionKey): any;
export declare class ComputeDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeDiskDiskEncryptionKey | undefined;
    set internalValue(value: ComputeDiskDiskEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface ComputeDiskSourceImageEncryptionKey {
    /**
    * The self link of the encryption key used to encrypt the disk. Also called KmsKeyName
  in the cloud console. Your project's Compute Engine System service account
  ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
  'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
  See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#kms_key_self_link ComputeDisk#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
  If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#kms_key_service_account ComputeDisk#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
  RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#raw_key ComputeDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function computeDiskSourceImageEncryptionKeyToTerraform(struct?: ComputeDiskSourceImageEncryptionKeyOutputReference | ComputeDiskSourceImageEncryptionKey): any;
export declare class ComputeDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeDiskSourceImageEncryptionKey | undefined;
    set internalValue(value: ComputeDiskSourceImageEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface ComputeDiskSourceSnapshotEncryptionKey {
    /**
    * The self link of the encryption key used to encrypt the disk. Also called KmsKeyName
  in the cloud console. Your project's Compute Engine System service account
  ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
  'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
  See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#kms_key_self_link ComputeDisk#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
  If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#kms_key_service_account ComputeDisk#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
  RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#raw_key ComputeDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function computeDiskSourceSnapshotEncryptionKeyToTerraform(struct?: ComputeDiskSourceSnapshotEncryptionKeyOutputReference | ComputeDiskSourceSnapshotEncryptionKey): any;
export declare class ComputeDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: ComputeDiskSourceSnapshotEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface ComputeDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#create ComputeDisk#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#delete ComputeDisk#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk#update ComputeDisk#update}
    */
    readonly update?: string;
}
export declare function computeDiskTimeoutsToTerraform(struct?: ComputeDiskTimeoutsOutputReference | ComputeDiskTimeouts | cdktf.IResolvable): any;
export declare class ComputeDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeDiskTimeouts | undefined;
    set internalValue(value: ComputeDiskTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_disk google_compute_disk}
*/
export declare class ComputeDisk extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_disk google_compute_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeDiskConfig
    */
    constructor(scope: Construct, id: string, config: ComputeDiskConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _physicalBlockSizeBytes?;
    get physicalBlockSizeBytes(): number;
    set physicalBlockSizeBytes(value: number);
    resetPhysicalBlockSizeBytes(): void;
    get physicalBlockSizeBytesInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _provisionedIops?;
    get provisionedIops(): number;
    set provisionedIops(value: number);
    resetProvisionedIops(): void;
    get provisionedIopsInput(): number | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _snapshot?;
    get snapshot(): string;
    set snapshot(value: string);
    resetSnapshot(): void;
    get snapshotInput(): string | undefined;
    get sourceImageId(): string;
    get sourceSnapshotId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get users(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _diskEncryptionKey;
    get diskEncryptionKey(): ComputeDiskDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: ComputeDiskDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): ComputeDiskDiskEncryptionKey | undefined;
    private _sourceImageEncryptionKey;
    get sourceImageEncryptionKey(): ComputeDiskSourceImageEncryptionKeyOutputReference;
    putSourceImageEncryptionKey(value: ComputeDiskSourceImageEncryptionKey): void;
    resetSourceImageEncryptionKey(): void;
    get sourceImageEncryptionKeyInput(): ComputeDiskSourceImageEncryptionKey | undefined;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): ComputeDiskSourceSnapshotEncryptionKeyOutputReference;
    putSourceSnapshotEncryptionKey(value: ComputeDiskSourceSnapshotEncryptionKey): void;
    resetSourceSnapshotEncryptionKey(): void;
    get sourceSnapshotEncryptionKeyInput(): ComputeDiskSourceSnapshotEncryptionKey | undefined;
    private _timeouts;
    get timeouts(): ComputeDiskTimeoutsOutputReference;
    putTimeouts(value: ComputeDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
