import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
    * How often (in seconds) to send a health check. The default value is 5
  seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#check_interval_sec ComputeHealthCheck#check_interval_sec}
    */
    readonly checkIntervalSec?: number;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#description ComputeHealthCheck#description}
    */
    readonly description?: string;
    /**
    * A so-far unhealthy instance will be marked healthy after this many
  consecutive successes. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#healthy_threshold ComputeHealthCheck#healthy_threshold}
    */
    readonly healthyThreshold?: number;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#name ComputeHealthCheck#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#project ComputeHealthCheck#project}
    */
    readonly project?: string;
    /**
    * How long (in seconds) to wait before claiming failure.
  The default value is 5 seconds.  It is invalid for timeoutSec to have
  greater value than checkIntervalSec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#timeout_sec ComputeHealthCheck#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * A so-far healthy instance will be marked unhealthy after this many
  consecutive failures. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#unhealthy_threshold ComputeHealthCheck#unhealthy_threshold}
    */
    readonly unhealthyThreshold?: number;
    /**
    * grpc_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#grpc_health_check ComputeHealthCheck#grpc_health_check}
    */
    readonly grpcHealthCheck?: ComputeHealthCheckGrpcHealthCheck;
    /**
    * http2_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#http2_health_check ComputeHealthCheck#http2_health_check}
    */
    readonly http2HealthCheck?: ComputeHealthCheckHttp2HealthCheck;
    /**
    * http_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#http_health_check ComputeHealthCheck#http_health_check}
    */
    readonly httpHealthCheck?: ComputeHealthCheckHttpHealthCheck;
    /**
    * https_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#https_health_check ComputeHealthCheck#https_health_check}
    */
    readonly httpsHealthCheck?: ComputeHealthCheckHttpsHealthCheck;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#log_config ComputeHealthCheck#log_config}
    */
    readonly logConfig?: ComputeHealthCheckLogConfig;
    /**
    * ssl_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#ssl_health_check ComputeHealthCheck#ssl_health_check}
    */
    readonly sslHealthCheck?: ComputeHealthCheckSslHealthCheck;
    /**
    * tcp_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#tcp_health_check ComputeHealthCheck#tcp_health_check}
    */
    readonly tcpHealthCheck?: ComputeHealthCheckTcpHealthCheck;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#timeouts ComputeHealthCheck#timeouts}
    */
    readonly timeouts?: ComputeHealthCheckTimeouts;
}
export interface ComputeHealthCheckGrpcHealthCheck {
    /**
    * The gRPC service name for the health check.
  The value of grpcServiceName has the following meanings by convention:
    - Empty serviceName means the overall status of all services at the backend.
    - Non-empty serviceName means the health of that gRPC service, as defined by the owner of the service.
  The grpcServiceName can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#grpc_service_name ComputeHealthCheck#grpc_service_name}
    */
    readonly grpcServiceName?: string;
    /**
    * The port number for the health check request.
  Must be specified if portName and portSpecification are not set
  or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port ComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_name ComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, gRPC health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_specification ComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
}
export declare function computeHealthCheckGrpcHealthCheckToTerraform(struct?: ComputeHealthCheckGrpcHealthCheckOutputReference | ComputeHealthCheckGrpcHealthCheck): any;
export declare class ComputeHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckGrpcHealthCheck | undefined;
    set internalValue(value: ComputeHealthCheckGrpcHealthCheck | undefined);
    private _grpcServiceName?;
    get grpcServiceName(): string;
    set grpcServiceName(value: string);
    resetGrpcServiceName(): void;
    get grpcServiceNameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
}
export interface ComputeHealthCheckHttp2HealthCheck {
    /**
    * The value of the host header in the HTTP2 health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#host ComputeHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP2 health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port ComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_name ComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTP2 health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_specification ComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#proxy_header ComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP2 health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#request_path ComputeHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#response ComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeHealthCheckHttp2HealthCheckToTerraform(struct?: ComputeHealthCheckHttp2HealthCheckOutputReference | ComputeHealthCheckHttp2HealthCheck): any;
export declare class ComputeHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckHttp2HealthCheck | undefined;
    set internalValue(value: ComputeHealthCheckHttp2HealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeHealthCheckHttpHealthCheck {
    /**
    * The value of the host header in the HTTP health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#host ComputeHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP health check request.
  The default value is 80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port ComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_name ComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTP health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_specification ComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#proxy_header ComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#request_path ComputeHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#response ComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeHealthCheckHttpHealthCheckToTerraform(struct?: ComputeHealthCheckHttpHealthCheckOutputReference | ComputeHealthCheckHttpHealthCheck): any;
export declare class ComputeHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckHttpHealthCheck | undefined;
    set internalValue(value: ComputeHealthCheckHttpHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeHealthCheckHttpsHealthCheck {
    /**
    * The value of the host header in the HTTPS health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#host ComputeHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTPS health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port ComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_name ComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTPS health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_specification ComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#proxy_header ComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTPS health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#request_path ComputeHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#response ComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeHealthCheckHttpsHealthCheckToTerraform(struct?: ComputeHealthCheckHttpsHealthCheckOutputReference | ComputeHealthCheckHttpsHealthCheck): any;
export declare class ComputeHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckHttpsHealthCheck | undefined;
    set internalValue(value: ComputeHealthCheckHttpsHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeHealthCheckLogConfig {
    /**
    * Indicates whether or not to export logs. This is false by default,
  which means no health check logging will be done.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#enable ComputeHealthCheck#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
}
export declare function computeHealthCheckLogConfigToTerraform(struct?: ComputeHealthCheckLogConfigOutputReference | ComputeHealthCheckLogConfig): any;
export declare class ComputeHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckLogConfig | undefined;
    set internalValue(value: ComputeHealthCheckLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeHealthCheckSslHealthCheck {
    /**
    * The TCP port number for the SSL health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port ComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_name ComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, SSL health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_specification ComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#proxy_header ComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the SSL connection has been
  established (default value is empty). If both request and response are
  empty, the connection establishment alone will indicate health. The request
  data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#request ComputeHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#response ComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeHealthCheckSslHealthCheckToTerraform(struct?: ComputeHealthCheckSslHealthCheckOutputReference | ComputeHealthCheckSslHealthCheck): any;
export declare class ComputeHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckSslHealthCheck | undefined;
    set internalValue(value: ComputeHealthCheckSslHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeHealthCheckTcpHealthCheck {
    /**
    * The TCP port number for the TCP health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port ComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_name ComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, TCP health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#port_specification ComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#proxy_header ComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the TCP connection has been
  established (default value is empty). If both request and response are
  empty, the connection establishment alone will indicate health. The request
  data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#request ComputeHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#response ComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeHealthCheckTcpHealthCheckToTerraform(struct?: ComputeHealthCheckTcpHealthCheckOutputReference | ComputeHealthCheckTcpHealthCheck): any;
export declare class ComputeHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckTcpHealthCheck | undefined;
    set internalValue(value: ComputeHealthCheckTcpHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeHealthCheckTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#create ComputeHealthCheck#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#delete ComputeHealthCheck#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_health_check#update ComputeHealthCheck#update}
    */
    readonly update?: string;
}
export declare function computeHealthCheckTimeoutsToTerraform(struct?: ComputeHealthCheckTimeoutsOutputReference | ComputeHealthCheckTimeouts | cdktf.IResolvable): any;
export declare class ComputeHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeHealthCheckTimeouts | undefined;
    set internalValue(value: ComputeHealthCheckTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_health_check google_compute_health_check}
*/
export declare class ComputeHealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_health_check google_compute_health_check} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeHealthCheckConfig
    */
    constructor(scope: Construct, id: string, config: ComputeHealthCheckConfig);
    private _checkIntervalSec?;
    get checkIntervalSec(): number;
    set checkIntervalSec(value: number);
    resetCheckIntervalSec(): void;
    get checkIntervalSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number;
    set healthyThreshold(value: number);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    get type(): string;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number;
    set unhealthyThreshold(value: number);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
    private _grpcHealthCheck;
    get grpcHealthCheck(): ComputeHealthCheckGrpcHealthCheckOutputReference;
    putGrpcHealthCheck(value: ComputeHealthCheckGrpcHealthCheck): void;
    resetGrpcHealthCheck(): void;
    get grpcHealthCheckInput(): ComputeHealthCheckGrpcHealthCheck | undefined;
    private _http2HealthCheck;
    get http2HealthCheck(): ComputeHealthCheckHttp2HealthCheckOutputReference;
    putHttp2HealthCheck(value: ComputeHealthCheckHttp2HealthCheck): void;
    resetHttp2HealthCheck(): void;
    get http2HealthCheckInput(): ComputeHealthCheckHttp2HealthCheck | undefined;
    private _httpHealthCheck;
    get httpHealthCheck(): ComputeHealthCheckHttpHealthCheckOutputReference;
    putHttpHealthCheck(value: ComputeHealthCheckHttpHealthCheck): void;
    resetHttpHealthCheck(): void;
    get httpHealthCheckInput(): ComputeHealthCheckHttpHealthCheck | undefined;
    private _httpsHealthCheck;
    get httpsHealthCheck(): ComputeHealthCheckHttpsHealthCheckOutputReference;
    putHttpsHealthCheck(value: ComputeHealthCheckHttpsHealthCheck): void;
    resetHttpsHealthCheck(): void;
    get httpsHealthCheckInput(): ComputeHealthCheckHttpsHealthCheck | undefined;
    private _logConfig;
    get logConfig(): ComputeHealthCheckLogConfigOutputReference;
    putLogConfig(value: ComputeHealthCheckLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeHealthCheckLogConfig | undefined;
    private _sslHealthCheck;
    get sslHealthCheck(): ComputeHealthCheckSslHealthCheckOutputReference;
    putSslHealthCheck(value: ComputeHealthCheckSslHealthCheck): void;
    resetSslHealthCheck(): void;
    get sslHealthCheckInput(): ComputeHealthCheckSslHealthCheck | undefined;
    private _tcpHealthCheck;
    get tcpHealthCheck(): ComputeHealthCheckTcpHealthCheckOutputReference;
    putTcpHealthCheck(value: ComputeHealthCheckTcpHealthCheck): void;
    resetTcpHealthCheck(): void;
    get tcpHealthCheckInput(): ComputeHealthCheckTcpHealthCheck | undefined;
    private _timeouts;
    get timeouts(): ComputeHealthCheckTimeoutsOutputReference;
    putTimeouts(value: ComputeHealthCheckTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeHealthCheckTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
