import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * When set to 'true', the network is created in "auto subnet mode" and
  it will create a subnet for each region automatically across the
  '10.128.0.0/9' address range.
  
  When set to 'false', the network is created in "custom subnet mode" so
  the user can explicitly connect subnetwork resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#auto_create_subnetworks ComputeNetwork#auto_create_subnetworks}
    */
    readonly autoCreateSubnetworks?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#delete_default_routes_on_create ComputeNetwork#delete_default_routes_on_create}
    */
    readonly deleteDefaultRoutesOnCreate?: boolean | cdktf.IResolvable;
    /**
    * An optional description of this resource. The resource must be
  recreated to modify this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#description ComputeNetwork#description}
    */
    readonly description?: string;
    /**
    * Maximum Transmission Unit in bytes. The minimum value for this field is 1460
  and the maximum value is 1500 bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#mtu ComputeNetwork#mtu}
    */
    readonly mtu?: number;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#name ComputeNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#project ComputeNetwork#project}
    */
    readonly project?: string;
    /**
    * The network-wide routing mode to use. If set to 'REGIONAL', this
  network's cloud routers will only advertise routes with subnetworks
  of this network in the same region as the router. If set to 'GLOBAL',
  this network's cloud routers will advertise routes with all
  subnetworks of this network, across regions. Possible values: ["REGIONAL", "GLOBAL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#routing_mode ComputeNetwork#routing_mode}
    */
    readonly routingMode?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#timeouts ComputeNetwork#timeouts}
    */
    readonly timeouts?: ComputeNetworkTimeouts;
}
export interface ComputeNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#create ComputeNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#delete ComputeNetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#update ComputeNetwork#update}
    */
    readonly update?: string;
}
export declare function computeNetworkTimeoutsToTerraform(struct?: ComputeNetworkTimeoutsOutputReference | ComputeNetworkTimeouts | cdktf.IResolvable): any;
export declare class ComputeNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeNetworkTimeouts | undefined;
    set internalValue(value: ComputeNetworkTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network google_compute_network}
*/
export declare class ComputeNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network google_compute_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNetworkConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNetworkConfig);
    private _autoCreateSubnetworks?;
    get autoCreateSubnetworks(): boolean | cdktf.IResolvable;
    set autoCreateSubnetworks(value: boolean | cdktf.IResolvable);
    resetAutoCreateSubnetworks(): void;
    get autoCreateSubnetworksInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteDefaultRoutesOnCreate?;
    get deleteDefaultRoutesOnCreate(): boolean | cdktf.IResolvable;
    set deleteDefaultRoutesOnCreate(value: boolean | cdktf.IResolvable);
    resetDeleteDefaultRoutesOnCreate(): void;
    get deleteDefaultRoutesOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get gatewayIpv4(): string;
    get id(): string;
    private _mtu?;
    get mtu(): number;
    set mtu(value: number);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _routingMode?;
    get routingMode(): string;
    set routingMode(value: string);
    resetRoutingMode(): void;
    get routingModeInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): ComputeNetworkTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
