import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeTargetGrpcProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#description ComputeTargetGrpcProxy#description}
    */
    readonly description?: string;
    /**
    * Name of the resource. Provided by the client when the resource
  is created. The name must be 1-63 characters long, and comply
  with RFC1035. Specifically, the name must be 1-63 characters long
  and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
  means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#name ComputeTargetGrpcProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#project ComputeTargetGrpcProxy#project}
    */
    readonly project?: string;
    /**
    * URL to the UrlMap resource that defines the mapping from URL to
  the BackendService. The protocol field in the BackendService
  must be set to GRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#url_map ComputeTargetGrpcProxy#url_map}
    */
    readonly urlMap?: string;
    /**
    * If true, indicates that the BackendServices referenced by
  the urlMap may be accessed by gRPC applications without using
  a sidecar proxy. This will enable configuration checks on urlMap
  and its referenced BackendServices to not allow unsupported features.
  A gRPC application must use "xds:///" scheme in the target URI
  of the service it is connecting to. If false, indicates that the
  BackendServices referenced by the urlMap will be accessed by gRPC
  applications via a sidecar proxy. In this case, a gRPC application
  must not use "xds:///" scheme in the target URI of the service
  it is connecting to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#validate_for_proxyless ComputeTargetGrpcProxy#validate_for_proxyless}
    */
    readonly validateForProxyless?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#timeouts ComputeTargetGrpcProxy#timeouts}
    */
    readonly timeouts?: ComputeTargetGrpcProxyTimeouts;
}
export interface ComputeTargetGrpcProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#create ComputeTargetGrpcProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#delete ComputeTargetGrpcProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy#update ComputeTargetGrpcProxy#update}
    */
    readonly update?: string;
}
export declare function computeTargetGrpcProxyTimeoutsToTerraform(struct?: ComputeTargetGrpcProxyTimeoutsOutputReference | ComputeTargetGrpcProxyTimeouts | cdktf.IResolvable): any;
export declare class ComputeTargetGrpcProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeTargetGrpcProxyTimeouts | undefined;
    set internalValue(value: ComputeTargetGrpcProxyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy google_compute_target_grpc_proxy}
*/
export declare class ComputeTargetGrpcProxy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_grpc_proxy google_compute_target_grpc_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeTargetGrpcProxyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeTargetGrpcProxyConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get selfLinkWithId(): string;
    private _urlMap?;
    get urlMap(): string;
    set urlMap(value: string);
    resetUrlMap(): void;
    get urlMapInput(): string | undefined;
    private _validateForProxyless?;
    get validateForProxyless(): boolean | cdktf.IResolvable;
    set validateForProxyless(value: boolean | cdktf.IResolvable);
    resetValidateForProxyless(): void;
    get validateForProxylessInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): ComputeTargetGrpcProxyTimeoutsOutputReference;
    putTimeouts(value: ComputeTargetGrpcProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeTargetGrpcProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
