import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeTargetHttpsProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#description ComputeTargetHttpsProxy#description}
    */
    readonly description?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#name ComputeTargetHttpsProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#project ComputeTargetHttpsProxy#project}
    */
    readonly project?: string;
    /**
    * This field only applies when the forwarding rule that references
  this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#proxy_bind ComputeTargetHttpsProxy#proxy_bind}
    */
    readonly proxyBind?: boolean | cdktf.IResolvable;
    /**
    * Specifies the QUIC override policy for this resource. This determines
  whether the load balancer will attempt to negotiate QUIC with clients
  or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
  specified, uses the QUIC policy with no user overrides, which is
  equivalent to DISABLE. Default value: "NONE" Possible values: ["NONE", "ENABLE", "DISABLE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#quic_override ComputeTargetHttpsProxy#quic_override}
    */
    readonly quicOverride?: string;
    /**
    * A list of SslCertificate resources that are used to authenticate
  connections between users and the load balancer. At least one SSL
  certificate must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#ssl_certificates ComputeTargetHttpsProxy#ssl_certificates}
    */
    readonly sslCertificates: string[];
    /**
    * A reference to the SslPolicy resource that will be associated with
  the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
  resource will not have any SSL policy configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#ssl_policy ComputeTargetHttpsProxy#ssl_policy}
    */
    readonly sslPolicy?: string;
    /**
    * A reference to the UrlMap resource that defines the mapping from URL
  to the BackendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#url_map ComputeTargetHttpsProxy#url_map}
    */
    readonly urlMap: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#timeouts ComputeTargetHttpsProxy#timeouts}
    */
    readonly timeouts?: ComputeTargetHttpsProxyTimeouts;
}
export interface ComputeTargetHttpsProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#create ComputeTargetHttpsProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#delete ComputeTargetHttpsProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#update ComputeTargetHttpsProxy#update}
    */
    readonly update?: string;
}
export declare function computeTargetHttpsProxyTimeoutsToTerraform(struct?: ComputeTargetHttpsProxyTimeoutsOutputReference | ComputeTargetHttpsProxyTimeouts | cdktf.IResolvable): any;
export declare class ComputeTargetHttpsProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeTargetHttpsProxyTimeouts | undefined;
    set internalValue(value: ComputeTargetHttpsProxyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy google_compute_target_https_proxy}
*/
export declare class ComputeTargetHttpsProxy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy google_compute_target_https_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeTargetHttpsProxyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeTargetHttpsProxyConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _proxyBind?;
    get proxyBind(): boolean | cdktf.IResolvable;
    set proxyBind(value: boolean | cdktf.IResolvable);
    resetProxyBind(): void;
    get proxyBindInput(): boolean | cdktf.IResolvable | undefined;
    get proxyId(): number;
    private _quicOverride?;
    get quicOverride(): string;
    set quicOverride(value: string);
    resetQuicOverride(): void;
    get quicOverrideInput(): string | undefined;
    get selfLink(): string;
    private _sslCertificates?;
    get sslCertificates(): string[];
    set sslCertificates(value: string[]);
    get sslCertificatesInput(): string[] | undefined;
    private _sslPolicy?;
    get sslPolicy(): string;
    set sslPolicy(value: string);
    resetSslPolicy(): void;
    get sslPolicyInput(): string | undefined;
    private _urlMap?;
    get urlMap(): string;
    set urlMap(value: string);
    get urlMapInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeTargetHttpsProxyTimeoutsOutputReference;
    putTimeouts(value: ComputeTargetHttpsProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeTargetHttpsProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
