import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeTargetInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#description ComputeTargetInstance#description}
    */
    readonly description?: string;
    /**
    * The Compute instance VM handling traffic for this target instance.
  Accepts the instance self-link, relative path
  (e.g. 'projects/project/zones/zone/instances/instance') or name. If
  name is given, the zone will default to the given zone or
  the provider-default zone and the project will default to the
  provider-level project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#instance ComputeTargetInstance#instance}
    */
    readonly instance: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#name ComputeTargetInstance#name}
    */
    readonly name: string;
    /**
    * NAT option controlling how IPs are NAT'ed to the instance.
  Currently only NO_NAT (default value) is supported. Default value: "NO_NAT" Possible values: ["NO_NAT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#nat_policy ComputeTargetInstance#nat_policy}
    */
    readonly natPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#project ComputeTargetInstance#project}
    */
    readonly project?: string;
    /**
    * URL of the zone where the target instance resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#zone ComputeTargetInstance#zone}
    */
    readonly zone?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#timeouts ComputeTargetInstance#timeouts}
    */
    readonly timeouts?: ComputeTargetInstanceTimeouts;
}
export interface ComputeTargetInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#create ComputeTargetInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance#delete ComputeTargetInstance#delete}
    */
    readonly delete?: string;
}
export declare function computeTargetInstanceTimeoutsToTerraform(struct?: ComputeTargetInstanceTimeoutsOutputReference | ComputeTargetInstanceTimeouts | cdktf.IResolvable): any;
export declare class ComputeTargetInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeTargetInstanceTimeouts | undefined;
    set internalValue(value: ComputeTargetInstanceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance google_compute_target_instance}
*/
export declare class ComputeTargetInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance google_compute_target_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeTargetInstanceConfig
    */
    constructor(scope: Construct, id: string, config: ComputeTargetInstanceConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natPolicy?;
    get natPolicy(): string;
    set natPolicy(value: string);
    resetNatPolicy(): void;
    get natPolicyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeTargetInstanceTimeoutsOutputReference;
    putTimeouts(value: ComputeTargetInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeTargetInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
