import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAnalysisOccurrenceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The analysis note associated with this occurrence, in the form of
  projects/[PROJECT]/notes/[NOTE_ID]. This field can be used as a
  filter in list requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#note_name ContainerAnalysisOccurrence#note_name}
    */
    readonly noteName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#project ContainerAnalysisOccurrence#project}
    */
    readonly project?: string;
    /**
    * A description of actions that can be taken to remedy the note.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#remediation ContainerAnalysisOccurrence#remediation}
    */
    readonly remediation?: string;
    /**
    * Required. Immutable. A URI that represents the resource for which
  the occurrence applies. For example,
  https://gcr.io/project/image@sha256:123abc for a Docker image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#resource_uri ContainerAnalysisOccurrence#resource_uri}
    */
    readonly resourceUri: string;
    /**
    * attestation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#attestation ContainerAnalysisOccurrence#attestation}
    */
    readonly attestation: ContainerAnalysisOccurrenceAttestation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#timeouts ContainerAnalysisOccurrence#timeouts}
    */
    readonly timeouts?: ContainerAnalysisOccurrenceTimeouts;
}
export interface ContainerAnalysisOccurrenceAttestationSignatures {
    /**
    * The identifier for the public key that verifies this
  signature. MUST be an RFC3986 conformant
  URI. * When possible, the key id should be an
  immutable reference, such as a cryptographic digest.
  Examples of valid values:
  
  * OpenPGP V4 public key fingerprint. See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr
    for more details on this scheme.
      * 'openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA'
  * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization):
      * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#public_key_id ContainerAnalysisOccurrence#public_key_id}
    */
    readonly publicKeyId: string;
    /**
    * The content of the signature, an opaque bytestring.
  The payload that this signature verifies MUST be
  unambiguously provided with the Signature during
  verification. A wrapper message might provide the
  payload explicitly. Alternatively, a message might
  have a canonical serialization that can always be
  unambiguously computed to derive the payload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#signature ContainerAnalysisOccurrence#signature}
    */
    readonly signature?: string;
}
export declare function containerAnalysisOccurrenceAttestationSignaturesToTerraform(struct?: ContainerAnalysisOccurrenceAttestationSignatures | cdktf.IResolvable): any;
export interface ContainerAnalysisOccurrenceAttestation {
    /**
    * The serialized payload that is verified by one or
  more signatures. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#serialized_payload ContainerAnalysisOccurrence#serialized_payload}
    */
    readonly serializedPayload: string;
    /**
    * signatures block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#signatures ContainerAnalysisOccurrence#signatures}
    */
    readonly signatures: ContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable;
}
export declare function containerAnalysisOccurrenceAttestationToTerraform(struct?: ContainerAnalysisOccurrenceAttestationOutputReference | ContainerAnalysisOccurrenceAttestation): any;
export declare class ContainerAnalysisOccurrenceAttestationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerAnalysisOccurrenceAttestation | undefined;
    set internalValue(value: ContainerAnalysisOccurrenceAttestation | undefined);
    private _serializedPayload?;
    get serializedPayload(): string;
    set serializedPayload(value: string);
    get serializedPayloadInput(): string | undefined;
    private _signatures?;
    get signatures(): ContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable;
    set signatures(value: ContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable);
    get signaturesInput(): cdktf.IResolvable | ContainerAnalysisOccurrenceAttestationSignatures[] | undefined;
}
export interface ContainerAnalysisOccurrenceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#create ContainerAnalysisOccurrence#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#delete ContainerAnalysisOccurrence#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#update ContainerAnalysisOccurrence#update}
    */
    readonly update?: string;
}
export declare function containerAnalysisOccurrenceTimeoutsToTerraform(struct?: ContainerAnalysisOccurrenceTimeoutsOutputReference | ContainerAnalysisOccurrenceTimeouts | cdktf.IResolvable): any;
export declare class ContainerAnalysisOccurrenceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerAnalysisOccurrenceTimeouts | undefined;
    set internalValue(value: ContainerAnalysisOccurrenceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence google_container_analysis_occurrence}
*/
export declare class ContainerAnalysisOccurrence extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence google_container_analysis_occurrence} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAnalysisOccurrenceConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAnalysisOccurrenceConfig);
    get createTime(): string;
    get id(): string;
    get kind(): string;
    get name(): string;
    private _noteName?;
    get noteName(): string;
    set noteName(value: string);
    get noteNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _remediation?;
    get remediation(): string;
    set remediation(value: string);
    resetRemediation(): void;
    get remediationInput(): string | undefined;
    private _resourceUri?;
    get resourceUri(): string;
    set resourceUri(value: string);
    get resourceUriInput(): string | undefined;
    get updateTime(): string;
    private _attestation;
    get attestation(): ContainerAnalysisOccurrenceAttestationOutputReference;
    putAttestation(value: ContainerAnalysisOccurrenceAttestation): void;
    get attestationInput(): ContainerAnalysisOccurrenceAttestation | undefined;
    private _timeouts;
    get timeouts(): ContainerAnalysisOccurrenceTimeoutsOutputReference;
    putTimeouts(value: ContainerAnalysisOccurrenceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerAnalysisOccurrenceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
