import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service#location DataGoogleCloudRunService#location}
    */
    readonly location: string;
    /**
    * Name must be unique within a namespace, within a Cloud Run region.
  Is required when creating resources. Name is primarily intended
  for creation idempotence and configuration definition. Cannot be updated.
  More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service#name DataGoogleCloudRunService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service#project DataGoogleCloudRunService#project}
    */
    readonly project?: string;
}
export declare class DataGoogleCloudRunServiceMetadata extends cdktf.ComplexComputedList {
    get annotations(): {
        [key: string]: string;
    };
    get generation(): number;
    get labels(): {
        [key: string]: string;
    };
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceStatusConditions extends cdktf.ComplexComputedList {
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunServiceStatus extends cdktf.ComplexComputedList {
    get conditions(): cdktf.IResolvable;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    get url(): string;
}
export declare class DataGoogleCloudRunServiceTemplateMetadata extends cdktf.ComplexComputedList {
    get annotations(): {
        [key: string]: string;
    };
    get generation(): number;
    get labels(): {
        [key: string]: string;
    };
    get name(): string;
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnv extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference extends cdktf.ComplexComputedList {
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef extends cdktf.ComplexComputedList {
    get localObjectReference(): cdktf.IResolvable;
    get optional(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference extends cdktf.ComplexComputedList {
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef extends cdktf.ComplexComputedList {
    get localObjectReference(): cdktf.IResolvable;
    get optional(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom extends cdktf.ComplexComputedList {
    get configMapRef(): cdktf.IResolvable;
    get prefix(): string;
    get secretRef(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersPorts extends cdktf.ComplexComputedList {
    get containerPort(): number;
    get name(): string;
    get protocol(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersResources extends cdktf.ComplexComputedList {
    get limits(): {
        [key: string]: string;
    };
    get requests(): {
        [key: string]: string;
    };
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainers extends cdktf.ComplexComputedList {
    get args(): string[];
    get command(): string[];
    get env(): cdktf.IResolvable;
    get envFrom(): cdktf.IResolvable;
    get image(): string;
    get ports(): cdktf.IResolvable;
    get resources(): cdktf.IResolvable;
    get workingDir(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpec extends cdktf.ComplexComputedList {
    get containerConcurrency(): number;
    get containers(): cdktf.IResolvable;
    get serviceAccountName(): string;
    get servingState(): string;
    get timeoutSeconds(): number;
}
export declare class DataGoogleCloudRunServiceTemplate extends cdktf.ComplexComputedList {
    get metadata(): cdktf.IResolvable;
    get spec(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTraffic extends cdktf.ComplexComputedList {
    get latestRevision(): cdktf.IResolvable;
    get percent(): number;
    get revisionName(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service google_cloud_run_service}
*/
export declare class DataGoogleCloudRunService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service google_cloud_run_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudRunServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudRunServiceConfig);
    get autogenerateRevisionName(): cdktf.IResolvable;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    metadata(index: string): DataGoogleCloudRunServiceMetadata;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    status(index: string): DataGoogleCloudRunServiceStatus;
    template(index: string): DataGoogleCloudRunServiceTemplate;
    traffic(index: string): DataGoogleCloudRunServiceTraffic;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
