import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeBackendBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket#name DataGoogleComputeBackendBucket#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket#project DataGoogleComputeBackendBucket#project}
    */
    readonly project?: string;
}
export declare class DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicy extends cdktf.ComplexComputedList {
    get code(): number;
    get ttl(): number;
}
export declare class DataGoogleComputeBackendBucketCdnPolicy extends cdktf.ComplexComputedList {
    get cacheMode(): string;
    get clientTtl(): number;
    get defaultTtl(): number;
    get maxTtl(): number;
    get negativeCaching(): cdktf.IResolvable;
    get negativeCachingPolicy(): cdktf.IResolvable;
    get serveWhileStale(): number;
    get signedUrlCacheMaxAgeSec(): number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket google_compute_backend_bucket}
*/
export declare class DataGoogleComputeBackendBucket extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket google_compute_backend_bucket} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeBackendBucketConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeBackendBucketConfig);
    get bucketName(): string;
    cdnPolicy(index: string): DataGoogleComputeBackendBucketCdnPolicy;
    get creationTimestamp(): string;
    get customResponseHeaders(): string[];
    get description(): string;
    get enableCdn(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
