import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeGlobalForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule#name DataGoogleComputeGlobalForwardingRule#name}
    */
    readonly name: string;
    /**
    * The project this resource belongs in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule#project DataGoogleComputeGlobalForwardingRule#project}
    */
    readonly project?: string;
}
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFilters extends cdktf.ComplexComputedList {
    get filterLabels(): cdktf.IResolvable;
    get filterMatchCriteria(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule google_compute_global_forwarding_rule}
*/
export declare class DataGoogleComputeGlobalForwardingRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule google_compute_global_forwarding_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeGlobalForwardingRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeGlobalForwardingRuleConfig);
    get description(): string;
    get id(): string;
    get ipAddress(): string;
    get ipProtocol(): string;
    get ipVersion(): string;
    get labelFingerprint(): string;
    labels(key: string): string | cdktf.IResolvable;
    get loadBalancingScheme(): string;
    metadataFilters(index: string): DataGoogleComputeGlobalForwardingRuleMetadataFilters;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    get portRange(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get target(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
