import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The location (region or zone) in which the cluster master will be created, as well as the default node location. If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster#location DataGoogleContainerCluster#location}
    */
    readonly location?: string;
    /**
    * The name of the cluster, unique within the project and location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster#name DataGoogleContainerCluster#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster#project DataGoogleContainerCluster#project}
    */
    readonly project?: string;
}
export declare class DataGoogleContainerClusterAddonsConfigCloudrunConfig extends cdktf.ComplexComputedList {
    get disabled(): cdktf.IResolvable;
    get loadBalancerType(): string;
}
export declare class DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscaling extends cdktf.ComplexComputedList {
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterAddonsConfigHttpLoadBalancing extends cdktf.ComplexComputedList {
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterAddonsConfigNetworkPolicyConfig extends cdktf.ComplexComputedList {
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterAddonsConfig extends cdktf.ComplexComputedList {
    get cloudrunConfig(): cdktf.IResolvable;
    get horizontalPodAutoscaling(): cdktf.IResolvable;
    get httpLoadBalancing(): cdktf.IResolvable;
    get networkPolicyConfig(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterAuthenticatorGroupsConfig extends cdktf.ComplexComputedList {
    get securityGroup(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults extends cdktf.ComplexComputedList {
    get oauthScopes(): string[];
    get serviceAccount(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscalingResourceLimits extends cdktf.ComplexComputedList {
    get maximum(): number;
    get minimum(): number;
    get resourceType(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscaling extends cdktf.ComplexComputedList {
    get autoProvisioningDefaults(): cdktf.IResolvable;
    get enabled(): cdktf.IResolvable;
    get resourceLimits(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterDatabaseEncryption extends cdktf.ComplexComputedList {
    get keyName(): string;
    get state(): string;
}
export declare class DataGoogleContainerClusterDefaultSnatStatus extends cdktf.ComplexComputedList {
    get disabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterIpAllocationPolicy extends cdktf.ComplexComputedList {
    get clusterIpv4CidrBlock(): string;
    get clusterSecondaryRangeName(): string;
    get servicesIpv4CidrBlock(): string;
    get servicesSecondaryRangeName(): string;
}
export declare class DataGoogleContainerClusterLoggingConfig extends cdktf.ComplexComputedList {
    get enableComponents(): string[];
}
export declare class DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow extends cdktf.ComplexComputedList {
    get duration(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusion extends cdktf.ComplexComputedList {
    get endTime(): string;
    get exclusionName(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicyRecurringWindow extends cdktf.ComplexComputedList {
    get endTime(): string;
    get recurrence(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicy extends cdktf.ComplexComputedList {
    get dailyMaintenanceWindow(): cdktf.IResolvable;
    get maintenanceExclusion(): cdktf.IResolvable;
    get recurringWindow(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterMasterAuthClientCertificateConfig extends cdktf.ComplexComputedList {
    get issueClientCertificate(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterMasterAuth extends cdktf.ComplexComputedList {
    get clientCertificate(): string;
    get clientCertificateConfig(): cdktf.IResolvable;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get password(): string;
    get username(): string;
}
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks extends cdktf.ComplexComputedList {
    get cidrBlock(): string;
    get displayName(): string;
}
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfig extends cdktf.ComplexComputedList {
    get cidrBlocks(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterMonitoringConfig extends cdktf.ComplexComputedList {
    get enableComponents(): string[];
}
export declare class DataGoogleContainerClusterNetworkPolicy extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
    get provider(): string;
}
export declare class DataGoogleContainerClusterNodeConfigGuestAccelerator extends cdktf.ComplexComputedList {
    get count(): number;
    get gpuPartitionSize(): string;
    get type(): string;
}
export declare class DataGoogleContainerClusterNodeConfigShieldedInstanceConfig extends cdktf.ComplexComputedList {
    get enableIntegrityMonitoring(): cdktf.IResolvable;
    get enableSecureBoot(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodeConfigTaint extends cdktf.ComplexComputedList {
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataGoogleContainerClusterNodeConfigWorkloadMetadataConfig extends cdktf.ComplexComputedList {
    get mode(): string;
    get nodeMetadata(): string;
}
export declare class DataGoogleContainerClusterNodeConfig extends cdktf.ComplexComputedList {
    get diskSizeGb(): number;
    get diskType(): string;
    get guestAccelerator(): cdktf.IResolvable;
    get imageType(): string;
    get labels(): {
        [key: string]: string;
    };
    get localSsdCount(): number;
    get machineType(): string;
    get metadata(): {
        [key: string]: string;
    };
    get minCpuPlatform(): string;
    get oauthScopes(): string[];
    get preemptible(): cdktf.IResolvable;
    get serviceAccount(): string;
    get shieldedInstanceConfig(): cdktf.IResolvable;
    get tags(): string[];
    get taint(): cdktf.IResolvable;
    get workloadMetadataConfig(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodePoolAutoscaling extends cdktf.ComplexComputedList {
    get maxNodeCount(): number;
    get minNodeCount(): number;
}
export declare class DataGoogleContainerClusterNodePoolManagement extends cdktf.ComplexComputedList {
    get autoRepair(): cdktf.IResolvable;
    get autoUpgrade(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigGuestAccelerator extends cdktf.ComplexComputedList {
    get count(): number;
    get gpuPartitionSize(): string;
    get type(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig extends cdktf.ComplexComputedList {
    get enableIntegrityMonitoring(): cdktf.IResolvable;
    get enableSecureBoot(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigTaint extends cdktf.ComplexComputedList {
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig extends cdktf.ComplexComputedList {
    get mode(): string;
    get nodeMetadata(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfig extends cdktf.ComplexComputedList {
    get diskSizeGb(): number;
    get diskType(): string;
    get guestAccelerator(): cdktf.IResolvable;
    get imageType(): string;
    get labels(): {
        [key: string]: string;
    };
    get localSsdCount(): number;
    get machineType(): string;
    get metadata(): {
        [key: string]: string;
    };
    get minCpuPlatform(): string;
    get oauthScopes(): string[];
    get preemptible(): cdktf.IResolvable;
    get serviceAccount(): string;
    get shieldedInstanceConfig(): cdktf.IResolvable;
    get tags(): string[];
    get taint(): cdktf.IResolvable;
    get workloadMetadataConfig(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterNodePoolUpgradeSettings extends cdktf.ComplexComputedList {
    get maxSurge(): number;
    get maxUnavailable(): number;
}
export declare class DataGoogleContainerClusterNodePool extends cdktf.ComplexComputedList {
    get autoscaling(): cdktf.IResolvable;
    get initialNodeCount(): number;
    get instanceGroupUrls(): string[];
    get management(): cdktf.IResolvable;
    get maxPodsPerNode(): number;
    get name(): string;
    get namePrefix(): string;
    get nodeConfig(): cdktf.IResolvable;
    get nodeCount(): number;
    get nodeLocations(): string[];
    get upgradeSettings(): cdktf.IResolvable;
    get version(): string;
}
export declare class DataGoogleContainerClusterPodSecurityPolicyConfig extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterPrivateClusterConfig extends cdktf.ComplexComputedList {
    get enablePrivateEndpoint(): cdktf.IResolvable;
    get enablePrivateNodes(): cdktf.IResolvable;
    get masterGlobalAccessConfig(): cdktf.IResolvable;
    get masterIpv4CidrBlock(): string;
    get peeringName(): string;
    get privateEndpoint(): string;
    get publicEndpoint(): string;
}
export declare class DataGoogleContainerClusterReleaseChannel extends cdktf.ComplexComputedList {
    get channel(): string;
}
export declare class DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestination extends cdktf.ComplexComputedList {
    get datasetId(): string;
}
export declare class DataGoogleContainerClusterResourceUsageExportConfig extends cdktf.ComplexComputedList {
    get bigqueryDestination(): cdktf.IResolvable;
    get enableNetworkEgressMetering(): cdktf.IResolvable;
    get enableResourceConsumptionMetering(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterVerticalPodAutoscaling extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleContainerClusterWorkloadIdentityConfig extends cdktf.ComplexComputedList {
    get identityNamespace(): string;
    get workloadPool(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/container_cluster google_container_cluster}
*/
export declare class DataGoogleContainerCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_cluster google_container_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleContainerClusterConfig);
    addonsConfig(index: string): DataGoogleContainerClusterAddonsConfig;
    authenticatorGroupsConfig(index: string): DataGoogleContainerClusterAuthenticatorGroupsConfig;
    clusterAutoscaling(index: string): DataGoogleContainerClusterClusterAutoscaling;
    get clusterIpv4Cidr(): string;
    databaseEncryption(index: string): DataGoogleContainerClusterDatabaseEncryption;
    get datapathProvider(): string;
    get defaultMaxPodsPerNode(): number;
    defaultSnatStatus(index: string): DataGoogleContainerClusterDefaultSnatStatus;
    get description(): string;
    get enableAutopilot(): cdktf.IResolvable;
    get enableBinaryAuthorization(): cdktf.IResolvable;
    get enableIntranodeVisibility(): cdktf.IResolvable;
    get enableKubernetesAlpha(): cdktf.IResolvable;
    get enableLegacyAbac(): cdktf.IResolvable;
    get enableShieldedNodes(): cdktf.IResolvable;
    get enableTpu(): cdktf.IResolvable;
    get endpoint(): string;
    get id(): string;
    get initialNodeCount(): number;
    get instanceGroupUrls(): string[];
    ipAllocationPolicy(index: string): DataGoogleContainerClusterIpAllocationPolicy;
    get labelFingerprint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    loggingConfig(index: string): DataGoogleContainerClusterLoggingConfig;
    get loggingService(): string;
    maintenancePolicy(index: string): DataGoogleContainerClusterMaintenancePolicy;
    masterAuth(index: string): DataGoogleContainerClusterMasterAuth;
    masterAuthorizedNetworksConfig(index: string): DataGoogleContainerClusterMasterAuthorizedNetworksConfig;
    get masterVersion(): string;
    get minMasterVersion(): string;
    monitoringConfig(index: string): DataGoogleContainerClusterMonitoringConfig;
    get monitoringService(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    networkPolicy(index: string): DataGoogleContainerClusterNetworkPolicy;
    get networkingMode(): string;
    nodeConfig(index: string): DataGoogleContainerClusterNodeConfig;
    get nodeLocations(): string[];
    nodePool(index: string): DataGoogleContainerClusterNodePool;
    get nodeVersion(): string;
    get operation(): string;
    podSecurityPolicyConfig(index: string): DataGoogleContainerClusterPodSecurityPolicyConfig;
    privateClusterConfig(index: string): DataGoogleContainerClusterPrivateClusterConfig;
    get privateIpv6GoogleAccess(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    releaseChannel(index: string): DataGoogleContainerClusterReleaseChannel;
    get removeDefaultNodePool(): cdktf.IResolvable;
    resourceLabels(key: string): string | cdktf.IResolvable;
    resourceUsageExportConfig(index: string): DataGoogleContainerClusterResourceUsageExportConfig;
    get selfLink(): string;
    get servicesIpv4Cidr(): string;
    get subnetwork(): string;
    get tpuIpv4CidrBlock(): string;
    verticalPodAutoscaling(index: string): DataGoogleContainerClusterVerticalPodAutoscaling;
    workloadIdentityConfig(index: string): DataGoogleContainerClusterWorkloadIdentityConfig;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
