import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsCryptoKeyVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version#crypto_key DataGoogleKmsCryptoKeyVersion#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version#version DataGoogleKmsCryptoKeyVersion#version}
    */
    readonly version?: number;
}
export declare class DataGoogleKmsCryptoKeyVersionPublicKey extends cdktf.ComplexComputedList {
    get algorithm(): string;
    get pem(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version google_kms_crypto_key_version}
*/
export declare class DataGoogleKmsCryptoKeyVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key_version google_kms_crypto_key_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsCryptoKeyVersionConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsCryptoKeyVersionConfig);
    get algorithm(): string;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    get id(): string;
    get name(): string;
    get protectionLevel(): string;
    publicKey(index: string): DataGoogleKmsCryptoKeyVersionPublicKey;
    get state(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
