import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleNetblockIpRangesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/netblock_ip_ranges#range_type DataGoogleNetblockIpRanges#range_type}
    */
    readonly rangeType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/netblock_ip_ranges google_netblock_ip_ranges}
*/
export declare class DataGoogleNetblockIpRanges extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/netblock_ip_ranges google_netblock_ip_ranges} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleNetblockIpRangesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleNetblockIpRangesConfig);
    get cidrBlocks(): string[];
    get cidrBlocksIpv4(): string[];
    get cidrBlocksIpv6(): string[];
    get id(): string;
    private _rangeType?;
    get rangeType(): string;
    set rangeType(value: string);
    resetRangeType(): void;
    get rangeTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
