import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The project ID. Changing this forces a new project to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project#project_id DataGoogleProject#project_id}
    */
    readonly projectId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/project google_project}
*/
export declare class DataGoogleProject extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/project google_project} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleProjectConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleProjectConfig);
    get autoCreateNetwork(): cdktf.IResolvable;
    get billingAccount(): string;
    get folderId(): string;
    get id(): string;
    labels(key: string): string | cdktf.IResolvable;
    get name(): string;
    get number(): string;
    get orgId(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    get skipDelete(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
