import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the instance. If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance#name DataGoogleSqlDatabaseInstance#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance#project DataGoogleSqlDatabaseInstance#project}
    */
    readonly project?: string;
}
export declare class DataGoogleSqlDatabaseInstanceClone extends cdktf.ComplexComputedList {
    get pointInTime(): string;
    get sourceInstanceName(): string;
}
export declare class DataGoogleSqlDatabaseInstanceIpAddress extends cdktf.ComplexComputedList {
    get ipAddress(): string;
    get timeToRetire(): string;
    get type(): string;
}
export declare class DataGoogleSqlDatabaseInstanceReplicaConfiguration extends cdktf.ComplexComputedList {
    get caCertificate(): string;
    get clientCertificate(): string;
    get clientKey(): string;
    get connectRetryInterval(): number;
    get dumpFilePath(): string;
    get failoverTarget(): cdktf.IResolvable;
    get masterHeartbeatPeriod(): number;
    get password(): string;
    get sslCipher(): string;
    get username(): string;
    get verifyServerCertificate(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstanceRestoreBackupContext extends cdktf.ComplexComputedList {
    get backupRunId(): number;
    get instanceId(): string;
    get project(): string;
}
export declare class DataGoogleSqlDatabaseInstanceServerCaCert extends cdktf.ComplexComputedList {
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings extends cdktf.ComplexComputedList {
    get retainedBackups(): number;
    get retentionUnit(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration extends cdktf.ComplexComputedList {
    get backupRetentionSettings(): cdktf.IResolvable;
    get binaryLogEnabled(): cdktf.IResolvable;
    get enabled(): cdktf.IResolvable;
    get location(): string;
    get pointInTimeRecoveryEnabled(): cdktf.IResolvable;
    get startTime(): string;
    get transactionLogRetentionDays(): number;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsInsightsConfig extends cdktf.ComplexComputedList {
    get queryInsightsEnabled(): cdktf.IResolvable;
    get queryStringLength(): number;
    get recordApplicationTags(): cdktf.IResolvable;
    get recordClientAddress(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks extends cdktf.ComplexComputedList {
    get expirationTime(): string;
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfiguration extends cdktf.ComplexComputedList {
    get authorizedNetworks(): cdktf.IResolvable;
    get ipv4Enabled(): cdktf.IResolvable;
    get privateNetwork(): string;
    get requireSsl(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsLocationPreference extends cdktf.ComplexComputedList {
    get followGaeApplication(): string;
    get zone(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow extends cdktf.ComplexComputedList {
    get day(): number;
    get hour(): number;
    get updateTrack(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettings extends cdktf.ComplexComputedList {
    get activationPolicy(): string;
    get authorizedGaeApplications(): string[];
    get availabilityType(): string;
    get backupConfiguration(): cdktf.IResolvable;
    get collation(): string;
    get crashSafeReplication(): cdktf.IResolvable;
    get databaseFlags(): cdktf.IResolvable;
    get diskAutoresize(): cdktf.IResolvable;
    get diskAutoresizeLimit(): number;
    get diskSize(): number;
    get diskType(): string;
    get insightsConfig(): cdktf.IResolvable;
    get ipConfiguration(): cdktf.IResolvable;
    get locationPreference(): cdktf.IResolvable;
    get maintenanceWindow(): cdktf.IResolvable;
    get pricingPlan(): string;
    get replicationType(): string;
    get tier(): string;
    get userLabels(): {
        [key: string]: string;
    };
    get version(): number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance google_sql_database_instance}
*/
export declare class DataGoogleSqlDatabaseInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance google_sql_database_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSqlDatabaseInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSqlDatabaseInstanceConfig);
    clone(index: string): DataGoogleSqlDatabaseInstanceClone;
    get connectionName(): string;
    get databaseVersion(): string;
    get deletionProtection(): cdktf.IResolvable;
    get firstIpAddress(): string;
    get id(): string;
    ipAddress(index: string): DataGoogleSqlDatabaseInstanceIpAddress;
    get masterInstanceName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get publicIpAddress(): string;
    get region(): string;
    replicaConfiguration(index: string): DataGoogleSqlDatabaseInstanceReplicaConfiguration;
    restoreBackupContext(index: string): DataGoogleSqlDatabaseInstanceRestoreBackupContext;
    get rootPassword(): string;
    get selfLink(): string;
    serverCaCert(index: string): DataGoogleSqlDatabaseInstanceServerCaCert;
    get serviceAccountEmailAddress(): string;
    settings(index: string): DataGoogleSqlDatabaseInstanceSettings;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
