import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocAutoscalingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The  location where the autoscaling policy should reside.
  The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#location DataprocAutoscalingPolicy#location}
    */
    readonly location?: string;
    /**
    * The policy id. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
  and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
  3 and 50 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#policy_id DataprocAutoscalingPolicy#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#project DataprocAutoscalingPolicy#project}
    */
    readonly project?: string;
    /**
    * basic_algorithm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#basic_algorithm DataprocAutoscalingPolicy#basic_algorithm}
    */
    readonly basicAlgorithm?: DataprocAutoscalingPolicyBasicAlgorithm;
    /**
    * secondary_worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#secondary_worker_config DataprocAutoscalingPolicy#secondary_worker_config}
    */
    readonly secondaryWorkerConfig?: DataprocAutoscalingPolicySecondaryWorkerConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#timeouts DataprocAutoscalingPolicy#timeouts}
    */
    readonly timeouts?: DataprocAutoscalingPolicyTimeouts;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#worker_config DataprocAutoscalingPolicy#worker_config}
    */
    readonly workerConfig?: DataprocAutoscalingPolicyWorkerConfig;
}
export interface DataprocAutoscalingPolicyBasicAlgorithmYarnConfig {
    /**
    * Timeout for YARN graceful decommissioning of Node Managers. Specifies the
  duration to wait for jobs to complete before forcefully removing workers
  (and potentially interrupting jobs). Only applicable to downscaling operations.
  
  Bounds: [0s, 1d].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#graceful_decommission_timeout DataprocAutoscalingPolicy#graceful_decommission_timeout}
    */
    readonly gracefulDecommissionTimeout: string;
    /**
    * Fraction of average pending memory in the last cooldown period for which to
  remove workers. A scale-down factor of 1 will result in scaling down so that there
  is no available memory remaining after the update (more aggressive scaling).
  A scale-down factor of 0 disables removing workers, which can be beneficial for
  autoscaling a single job.
  
  Bounds: [0.0, 1.0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_down_factor DataprocAutoscalingPolicy#scale_down_factor}
    */
    readonly scaleDownFactor: number;
    /**
    * Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
  For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
  recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
  means the autoscaler will scale down on any recommended change.
  
  Bounds: [0.0, 1.0]. Default: 0.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_down_min_worker_fraction DataprocAutoscalingPolicy#scale_down_min_worker_fraction}
    */
    readonly scaleDownMinWorkerFraction?: number;
    /**
    * Fraction of average pending memory in the last cooldown period for which to
  add workers. A scale-up factor of 1.0 will result in scaling up so that there
  is no pending memory remaining after the update (more aggressive scaling).
  A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
  (less aggressive scaling).
  
  Bounds: [0.0, 1.0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_up_factor DataprocAutoscalingPolicy#scale_up_factor}
    */
    readonly scaleUpFactor: number;
    /**
    * Minimum scale-up threshold as a fraction of total cluster size before scaling
  occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
  must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
  0 means the autoscaler will scale up on any recommended change.
  
  Bounds: [0.0, 1.0]. Default: 0.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_up_min_worker_fraction DataprocAutoscalingPolicy#scale_up_min_worker_fraction}
    */
    readonly scaleUpMinWorkerFraction?: number;
}
export declare function dataprocAutoscalingPolicyBasicAlgorithmYarnConfigToTerraform(struct?: DataprocAutoscalingPolicyBasicAlgorithmYarnConfigOutputReference | DataprocAutoscalingPolicyBasicAlgorithmYarnConfig): any;
export declare class DataprocAutoscalingPolicyBasicAlgorithmYarnConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataprocAutoscalingPolicyBasicAlgorithmYarnConfig | undefined;
    set internalValue(value: DataprocAutoscalingPolicyBasicAlgorithmYarnConfig | undefined);
    private _gracefulDecommissionTimeout?;
    get gracefulDecommissionTimeout(): string;
    set gracefulDecommissionTimeout(value: string);
    get gracefulDecommissionTimeoutInput(): string | undefined;
    private _scaleDownFactor?;
    get scaleDownFactor(): number;
    set scaleDownFactor(value: number);
    get scaleDownFactorInput(): number | undefined;
    private _scaleDownMinWorkerFraction?;
    get scaleDownMinWorkerFraction(): number;
    set scaleDownMinWorkerFraction(value: number);
    resetScaleDownMinWorkerFraction(): void;
    get scaleDownMinWorkerFractionInput(): number | undefined;
    private _scaleUpFactor?;
    get scaleUpFactor(): number;
    set scaleUpFactor(value: number);
    get scaleUpFactorInput(): number | undefined;
    private _scaleUpMinWorkerFraction?;
    get scaleUpMinWorkerFraction(): number;
    set scaleUpMinWorkerFraction(value: number);
    resetScaleUpMinWorkerFraction(): void;
    get scaleUpMinWorkerFractionInput(): number | undefined;
}
export interface DataprocAutoscalingPolicyBasicAlgorithm {
    /**
    * Duration between scaling events. A scaling period starts after the
  update operation from the previous event has completed.
  
  Bounds: [2m, 1d]. Default: 2m.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#cooldown_period DataprocAutoscalingPolicy#cooldown_period}
    */
    readonly cooldownPeriod?: string;
    /**
    * yarn_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#yarn_config DataprocAutoscalingPolicy#yarn_config}
    */
    readonly yarnConfig: DataprocAutoscalingPolicyBasicAlgorithmYarnConfig;
}
export declare function dataprocAutoscalingPolicyBasicAlgorithmToTerraform(struct?: DataprocAutoscalingPolicyBasicAlgorithmOutputReference | DataprocAutoscalingPolicyBasicAlgorithm): any;
export declare class DataprocAutoscalingPolicyBasicAlgorithmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataprocAutoscalingPolicyBasicAlgorithm | undefined;
    set internalValue(value: DataprocAutoscalingPolicyBasicAlgorithm | undefined);
    private _cooldownPeriod?;
    get cooldownPeriod(): string;
    set cooldownPeriod(value: string);
    resetCooldownPeriod(): void;
    get cooldownPeriodInput(): string | undefined;
    private _yarnConfig;
    get yarnConfig(): DataprocAutoscalingPolicyBasicAlgorithmYarnConfigOutputReference;
    putYarnConfig(value: DataprocAutoscalingPolicyBasicAlgorithmYarnConfig): void;
    get yarnConfigInput(): DataprocAutoscalingPolicyBasicAlgorithmYarnConfig | undefined;
}
export interface DataprocAutoscalingPolicySecondaryWorkerConfig {
    /**
    * Maximum number of instances for this group. Note that by default, clusters will not use
  secondary workers. Required for secondary workers if the minimum secondary instances is set.
  Bounds: [minInstances, ). Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#max_instances DataprocAutoscalingPolicy#max_instances}
    */
    readonly maxInstances?: number;
    /**
    * Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#min_instances DataprocAutoscalingPolicy#min_instances}
    */
    readonly minInstances?: number;
    /**
    * Weight for the instance group, which is used to determine the fraction of total workers
  in the cluster from this instance group. For example, if primary workers have weight 2,
  and secondary workers have weight 1, the cluster will have approximately 2 primary workers
  for each secondary worker.
  
  The cluster may not reach the specified balance if constrained by min/max bounds or other
  autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
  primary workers will be added. The cluster can also be out of balance when created.
  
  If weight is not set on any instance group, the cluster will default to equal weight for
  all groups: the cluster will attempt to maintain an equal number of workers in each group
  within the configured size bounds for each group. If weight is set for one group only,
  the cluster will default to zero weight on the unset group. For example if weight is set
  only on primary workers, the cluster will use primary workers only and no secondary workers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#weight DataprocAutoscalingPolicy#weight}
    */
    readonly weight?: number;
}
export declare function dataprocAutoscalingPolicySecondaryWorkerConfigToTerraform(struct?: DataprocAutoscalingPolicySecondaryWorkerConfigOutputReference | DataprocAutoscalingPolicySecondaryWorkerConfig): any;
export declare class DataprocAutoscalingPolicySecondaryWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataprocAutoscalingPolicySecondaryWorkerConfig | undefined;
    set internalValue(value: DataprocAutoscalingPolicySecondaryWorkerConfig | undefined);
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export interface DataprocAutoscalingPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#create DataprocAutoscalingPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#delete DataprocAutoscalingPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#update DataprocAutoscalingPolicy#update}
    */
    readonly update?: string;
}
export declare function dataprocAutoscalingPolicyTimeoutsToTerraform(struct?: DataprocAutoscalingPolicyTimeoutsOutputReference | DataprocAutoscalingPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataprocAutoscalingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataprocAutoscalingPolicyTimeouts | undefined;
    set internalValue(value: DataprocAutoscalingPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataprocAutoscalingPolicyWorkerConfig {
    /**
    * Maximum number of instances for this group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#max_instances DataprocAutoscalingPolicy#max_instances}
    */
    readonly maxInstances: number;
    /**
    * Minimum number of instances for this group. Bounds: [2, maxInstances]. Defaults to 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#min_instances DataprocAutoscalingPolicy#min_instances}
    */
    readonly minInstances?: number;
    /**
    * Weight for the instance group, which is used to determine the fraction of total workers
  in the cluster from this instance group. For example, if primary workers have weight 2,
  and secondary workers have weight 1, the cluster will have approximately 2 primary workers
  for each secondary worker.
  
  The cluster may not reach the specified balance if constrained by min/max bounds or other
  autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
  primary workers will be added. The cluster can also be out of balance when created.
  
  If weight is not set on any instance group, the cluster will default to equal weight for
  all groups: the cluster will attempt to maintain an equal number of workers in each group
  within the configured size bounds for each group. If weight is set for one group only,
  the cluster will default to zero weight on the unset group. For example if weight is set
  only on primary workers, the cluster will use primary workers only and no secondary workers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#weight DataprocAutoscalingPolicy#weight}
    */
    readonly weight?: number;
}
export declare function dataprocAutoscalingPolicyWorkerConfigToTerraform(struct?: DataprocAutoscalingPolicyWorkerConfigOutputReference | DataprocAutoscalingPolicyWorkerConfig): any;
export declare class DataprocAutoscalingPolicyWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataprocAutoscalingPolicyWorkerConfig | undefined;
    set internalValue(value: DataprocAutoscalingPolicyWorkerConfig | undefined);
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy google_dataproc_autoscaling_policy}
*/
export declare class DataprocAutoscalingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy google_dataproc_autoscaling_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataprocAutoscalingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataprocAutoscalingPolicyConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _basicAlgorithm;
    get basicAlgorithm(): DataprocAutoscalingPolicyBasicAlgorithmOutputReference;
    putBasicAlgorithm(value: DataprocAutoscalingPolicyBasicAlgorithm): void;
    resetBasicAlgorithm(): void;
    get basicAlgorithmInput(): DataprocAutoscalingPolicyBasicAlgorithm | undefined;
    private _secondaryWorkerConfig;
    get secondaryWorkerConfig(): DataprocAutoscalingPolicySecondaryWorkerConfigOutputReference;
    putSecondaryWorkerConfig(value: DataprocAutoscalingPolicySecondaryWorkerConfig): void;
    resetSecondaryWorkerConfig(): void;
    get secondaryWorkerConfigInput(): DataprocAutoscalingPolicySecondaryWorkerConfig | undefined;
    private _timeouts;
    get timeouts(): DataprocAutoscalingPolicyTimeoutsOutputReference;
    putTimeouts(value: DataprocAutoscalingPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataprocAutoscalingPolicyTimeouts | undefined;
    private _workerConfig;
    get workerConfig(): DataprocAutoscalingPolicyWorkerConfigOutputReference;
    putWorkerConfig(value: DataprocAutoscalingPolicyWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): DataprocAutoscalingPolicyWorkerConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
