import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeploymentManagerDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set the policy to use for creating new resources. Only used on
  create and update. Valid values are 'CREATE_OR_ACQUIRE' (default) or
  'ACQUIRE'. If set to 'ACQUIRE' and resources do not already exist,
  the deployment will fail. Note that updating this field does not
  actually affect the deployment, just how it is updated. Default value: "CREATE_OR_ACQUIRE" Possible values: ["ACQUIRE", "CREATE_OR_ACQUIRE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#create_policy DeploymentManagerDeployment#create_policy}
    */
    readonly createPolicy?: string;
    /**
    * Set the policy to use for deleting new resources on update/delete.
  Valid values are 'DELETE' (default) or 'ABANDON'. If 'DELETE',
  resource is deleted after removal from Deployment Manager. If
  'ABANDON', the resource is only removed from Deployment Manager
  and is not actually deleted. Note that updating this field does not
  actually change the deployment, just how it is updated. Default value: "DELETE" Possible values: ["ABANDON", "DELETE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#delete_policy DeploymentManagerDeployment#delete_policy}
    */
    readonly deletePolicy?: string;
    /**
    * Optional user-provided description of deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#description DeploymentManagerDeployment#description}
    */
    readonly description?: string;
    /**
    * Unique name for the deployment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#name DeploymentManagerDeployment#name}
    */
    readonly name: string;
    /**
    * If set to true, a deployment is created with "shell" resources
  that are not actually instantiated. This allows you to preview a
  deployment. It can be updated to false to actually deploy
  with real resources.
   ~>**NOTE:** Deployment Manager does not allow update
  of a deployment in preview (unless updating to preview=false). Thus,
  Terraform will force-recreate deployments if either preview is updated
  to true or if other fields are updated while preview is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#preview DeploymentManagerDeployment#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#project DeploymentManagerDeployment#project}
    */
    readonly project?: string;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#labels DeploymentManagerDeployment#labels}
    */
    readonly labels?: DeploymentManagerDeploymentLabels[] | cdktf.IResolvable;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#target DeploymentManagerDeployment#target}
    */
    readonly target: DeploymentManagerDeploymentTarget;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#timeouts DeploymentManagerDeployment#timeouts}
    */
    readonly timeouts?: DeploymentManagerDeploymentTimeouts;
}
export interface DeploymentManagerDeploymentLabels {
    /**
    * Key for label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#key DeploymentManagerDeployment#key}
    */
    readonly key?: string;
    /**
    * Value of label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#value DeploymentManagerDeployment#value}
    */
    readonly value?: string;
}
export declare function deploymentManagerDeploymentLabelsToTerraform(struct?: DeploymentManagerDeploymentLabels | cdktf.IResolvable): any;
export interface DeploymentManagerDeploymentTargetConfig {
    /**
    * The full YAML contents of your configuration file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#content DeploymentManagerDeployment#content}
    */
    readonly content: string;
}
export declare function deploymentManagerDeploymentTargetConfigToTerraform(struct?: DeploymentManagerDeploymentTargetConfigOutputReference | DeploymentManagerDeploymentTargetConfig): any;
export declare class DeploymentManagerDeploymentTargetConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DeploymentManagerDeploymentTargetConfig | undefined;
    set internalValue(value: DeploymentManagerDeploymentTargetConfig | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
}
export interface DeploymentManagerDeploymentTargetImports {
    /**
    * The full contents of the template that you want to import.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#content DeploymentManagerDeployment#content}
    */
    readonly content?: string;
    /**
    * The name of the template to import, as declared in the YAML
  configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#name DeploymentManagerDeployment#name}
    */
    readonly name?: string;
}
export declare function deploymentManagerDeploymentTargetImportsToTerraform(struct?: DeploymentManagerDeploymentTargetImports | cdktf.IResolvable): any;
export interface DeploymentManagerDeploymentTarget {
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#config DeploymentManagerDeployment#config}
    */
    readonly config: DeploymentManagerDeploymentTargetConfig;
    /**
    * imports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#imports DeploymentManagerDeployment#imports}
    */
    readonly imports?: DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable;
}
export declare function deploymentManagerDeploymentTargetToTerraform(struct?: DeploymentManagerDeploymentTargetOutputReference | DeploymentManagerDeploymentTarget): any;
export declare class DeploymentManagerDeploymentTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DeploymentManagerDeploymentTarget | undefined;
    set internalValue(value: DeploymentManagerDeploymentTarget | undefined);
    private _config;
    get config(): DeploymentManagerDeploymentTargetConfigOutputReference;
    putConfig(value: DeploymentManagerDeploymentTargetConfig): void;
    get configInput(): DeploymentManagerDeploymentTargetConfig | undefined;
    private _imports?;
    get imports(): DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable;
    set imports(value: DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable);
    resetImports(): void;
    get importsInput(): cdktf.IResolvable | DeploymentManagerDeploymentTargetImports[] | undefined;
}
export interface DeploymentManagerDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#create DeploymentManagerDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#delete DeploymentManagerDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#update DeploymentManagerDeployment#update}
    */
    readonly update?: string;
}
export declare function deploymentManagerDeploymentTimeoutsToTerraform(struct?: DeploymentManagerDeploymentTimeoutsOutputReference | DeploymentManagerDeploymentTimeouts | cdktf.IResolvable): any;
export declare class DeploymentManagerDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DeploymentManagerDeploymentTimeouts | undefined;
    set internalValue(value: DeploymentManagerDeploymentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment google_deployment_manager_deployment}
*/
export declare class DeploymentManagerDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment google_deployment_manager_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DeploymentManagerDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: DeploymentManagerDeploymentConfig);
    private _createPolicy?;
    get createPolicy(): string;
    set createPolicy(value: string);
    resetCreatePolicy(): void;
    get createPolicyInput(): string | undefined;
    private _deletePolicy?;
    get deletePolicy(): string;
    set deletePolicy(value: string);
    resetDeletePolicy(): void;
    get deletePolicyInput(): string | undefined;
    get deploymentId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get manifest(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable;
    set preview(value: boolean | cdktf.IResolvable);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _labels?;
    get labels(): DeploymentManagerDeploymentLabels[] | cdktf.IResolvable;
    set labels(value: DeploymentManagerDeploymentLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | DeploymentManagerDeploymentLabels[] | undefined;
    private _target;
    get target(): DeploymentManagerDeploymentTargetOutputReference;
    putTarget(value: DeploymentManagerDeploymentTarget): void;
    get targetInput(): DeploymentManagerDeploymentTarget | undefined;
    private _timeouts;
    get timeouts(): DeploymentManagerDeploymentTimeoutsOutputReference;
    putTimeouts(value: DeploymentManagerDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DeploymentManagerDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
