import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxAgentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#avatar_uri DialogflowCxAgent#avatar_uri}
    */
    readonly avatarUri?: string;
    /**
    * The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
  for a list of the currently supported language codes. This field cannot be updated after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#default_language_code DialogflowCxAgent#default_language_code}
    */
    readonly defaultLanguageCode: string;
    /**
    * The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#description DialogflowCxAgent#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the agent, unique within the location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#display_name DialogflowCxAgent#display_name}
    */
    readonly displayName: string;
    /**
    * Indicates if automatic spell correction is enabled in detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#enable_spell_correction DialogflowCxAgent#enable_spell_correction}
    */
    readonly enableSpellCorrection?: boolean | cdktf.IResolvable;
    /**
    * Determines whether this agent should log conversation queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#enable_stackdriver_logging DialogflowCxAgent#enable_stackdriver_logging}
    */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
    * The name of the location this agent is located in.
  
  ~> **Note:** The first time you are deploying an Agent in your project you must configure location settings.
   This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
   Another options is to use global location so you don't need to manually configure location settings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#location DialogflowCxAgent#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#project DialogflowCxAgent#project}
    */
    readonly project?: string;
    /**
    * Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#security_settings DialogflowCxAgent#security_settings}
    */
    readonly securitySettings?: string;
    /**
    * The list of all languages supported by this agent (except for the default_language_code).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#supported_language_codes DialogflowCxAgent#supported_language_codes}
    */
    readonly supportedLanguageCodes?: string[];
    /**
    * The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
  Europe/Paris.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#time_zone DialogflowCxAgent#time_zone}
    */
    readonly timeZone: string;
    /**
    * speech_to_text_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#speech_to_text_settings DialogflowCxAgent#speech_to_text_settings}
    */
    readonly speechToTextSettings?: DialogflowCxAgentSpeechToTextSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#timeouts DialogflowCxAgent#timeouts}
    */
    readonly timeouts?: DialogflowCxAgentTimeouts;
}
export interface DialogflowCxAgentSpeechToTextSettings {
    /**
    * Whether to use speech adaptation for speech recognition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#enable_speech_adaptation DialogflowCxAgent#enable_speech_adaptation}
    */
    readonly enableSpeechAdaptation?: boolean | cdktf.IResolvable;
}
export declare function dialogflowCxAgentSpeechToTextSettingsToTerraform(struct?: DialogflowCxAgentSpeechToTextSettingsOutputReference | DialogflowCxAgentSpeechToTextSettings): any;
export declare class DialogflowCxAgentSpeechToTextSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxAgentSpeechToTextSettings | undefined;
    set internalValue(value: DialogflowCxAgentSpeechToTextSettings | undefined);
    private _enableSpeechAdaptation?;
    get enableSpeechAdaptation(): boolean | cdktf.IResolvable;
    set enableSpeechAdaptation(value: boolean | cdktf.IResolvable);
    resetEnableSpeechAdaptation(): void;
    get enableSpeechAdaptationInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DialogflowCxAgentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#create DialogflowCxAgent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#delete DialogflowCxAgent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent#update DialogflowCxAgent#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxAgentTimeoutsToTerraform(struct?: DialogflowCxAgentTimeoutsOutputReference | DialogflowCxAgentTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxAgentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxAgentTimeouts | undefined;
    set internalValue(value: DialogflowCxAgentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent google_dialogflow_cx_agent}
*/
export declare class DialogflowCxAgent extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent google_dialogflow_cx_agent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxAgentConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxAgentConfig);
    private _avatarUri?;
    get avatarUri(): string;
    set avatarUri(value: string);
    resetAvatarUri(): void;
    get avatarUriInput(): string | undefined;
    private _defaultLanguageCode?;
    get defaultLanguageCode(): string;
    set defaultLanguageCode(value: string);
    get defaultLanguageCodeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableSpellCorrection?;
    get enableSpellCorrection(): boolean | cdktf.IResolvable;
    set enableSpellCorrection(value: boolean | cdktf.IResolvable);
    resetEnableSpellCorrection(): void;
    get enableSpellCorrectionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _securitySettings?;
    get securitySettings(): string;
    set securitySettings(value: string);
    resetSecuritySettings(): void;
    get securitySettingsInput(): string | undefined;
    get startFlow(): string;
    private _supportedLanguageCodes?;
    get supportedLanguageCodes(): string[];
    set supportedLanguageCodes(value: string[]);
    resetSupportedLanguageCodes(): void;
    get supportedLanguageCodesInput(): string[] | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _speechToTextSettings;
    get speechToTextSettings(): DialogflowCxAgentSpeechToTextSettingsOutputReference;
    putSpeechToTextSettings(value: DialogflowCxAgentSpeechToTextSettings): void;
    resetSpeechToTextSettings(): void;
    get speechToTextSettingsInput(): DialogflowCxAgentSpeechToTextSettings | undefined;
    private _timeouts;
    get timeouts(): DialogflowCxAgentTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxAgentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxAgentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
