import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxEntityTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Represents kinds of entities.
  * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
  * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity. Possible values: ["AUTO_EXPANSION_MODE_DEFAULT", "AUTO_EXPANSION_MODE_UNSPECIFIED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#auto_expansion_mode DialogflowCxEntityType#auto_expansion_mode}
    */
    readonly autoExpansionMode?: string;
    /**
    * The human-readable name of the entity type, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#display_name DialogflowCxEntityType#display_name}
    */
    readonly displayName: string;
    /**
    * Enables fuzzy entity extraction during classification.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#enable_fuzzy_extraction DialogflowCxEntityType#enable_fuzzy_extraction}
    */
    readonly enableFuzzyExtraction?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the entity type can be automatically expanded.
  * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
  * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
  * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values. Possible values: ["KIND_MAP", "KIND_LIST", "KIND_REGEXP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#kind DialogflowCxEntityType#kind}
    */
    readonly kind: string;
    /**
    * The language of the following fields in entityType:
  EntityType.entities.value
  EntityType.entities.synonyms
  EntityType.excluded_phrases.value
  If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#language_code DialogflowCxEntityType#language_code}
    */
    readonly languageCode?: string;
    /**
    * The agent to create a entity type for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#parent DialogflowCxEntityType#parent}
    */
    readonly parent?: string;
    /**
    * Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#redact DialogflowCxEntityType#redact}
    */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
    * entities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#entities DialogflowCxEntityType#entities}
    */
    readonly entities: DialogflowCxEntityTypeEntities[] | cdktf.IResolvable;
    /**
    * excluded_phrases block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#excluded_phrases DialogflowCxEntityType#excluded_phrases}
    */
    readonly excludedPhrases?: DialogflowCxEntityTypeExcludedPhrases[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#timeouts DialogflowCxEntityType#timeouts}
    */
    readonly timeouts?: DialogflowCxEntityTypeTimeouts;
}
export interface DialogflowCxEntityTypeEntities {
    /**
    * A collection of value synonyms. For example, if the entity type is vegetable, and value is scallions, a synonym could be green onions.
  For KIND_LIST entity types: This collection must contain exactly one synonym equal to value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#synonyms DialogflowCxEntityType#synonyms}
    */
    readonly synonyms?: string[];
    /**
    * The primary value associated with this entity entry. For example, if the entity type is vegetable, the value could be scallions.
  For KIND_MAP entity types: A canonical value to be used in place of synonyms.
  For KIND_LIST entity types: A string that can contain references to other entity types (with or without aliases).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#value DialogflowCxEntityType#value}
    */
    readonly value?: string;
}
export declare function dialogflowCxEntityTypeEntitiesToTerraform(struct?: DialogflowCxEntityTypeEntities | cdktf.IResolvable): any;
export interface DialogflowCxEntityTypeExcludedPhrases {
    /**
    * The word or phrase to be excluded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#value DialogflowCxEntityType#value}
    */
    readonly value?: string;
}
export declare function dialogflowCxEntityTypeExcludedPhrasesToTerraform(struct?: DialogflowCxEntityTypeExcludedPhrases | cdktf.IResolvable): any;
export interface DialogflowCxEntityTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#create DialogflowCxEntityType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#delete DialogflowCxEntityType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type#update DialogflowCxEntityType#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxEntityTypeTimeoutsToTerraform(struct?: DialogflowCxEntityTypeTimeoutsOutputReference | DialogflowCxEntityTypeTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxEntityTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxEntityTypeTimeouts | undefined;
    set internalValue(value: DialogflowCxEntityTypeTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type google_dialogflow_cx_entity_type}
*/
export declare class DialogflowCxEntityType extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type google_dialogflow_cx_entity_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxEntityTypeConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxEntityTypeConfig);
    private _autoExpansionMode?;
    get autoExpansionMode(): string;
    set autoExpansionMode(value: string);
    resetAutoExpansionMode(): void;
    get autoExpansionModeInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableFuzzyExtraction?;
    get enableFuzzyExtraction(): boolean | cdktf.IResolvable;
    set enableFuzzyExtraction(value: boolean | cdktf.IResolvable);
    resetEnableFuzzyExtraction(): void;
    get enableFuzzyExtractionInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _redact?;
    get redact(): boolean | cdktf.IResolvable;
    set redact(value: boolean | cdktf.IResolvable);
    resetRedact(): void;
    get redactInput(): boolean | cdktf.IResolvable | undefined;
    private _entities?;
    get entities(): DialogflowCxEntityTypeEntities[] | cdktf.IResolvable;
    set entities(value: DialogflowCxEntityTypeEntities[] | cdktf.IResolvable);
    get entitiesInput(): cdktf.IResolvable | DialogflowCxEntityTypeEntities[] | undefined;
    private _excludedPhrases?;
    get excludedPhrases(): DialogflowCxEntityTypeExcludedPhrases[] | cdktf.IResolvable;
    set excludedPhrases(value: DialogflowCxEntityTypeExcludedPhrases[] | cdktf.IResolvable);
    resetExcludedPhrases(): void;
    get excludedPhrasesInput(): cdktf.IResolvable | DialogflowCxEntityTypeExcludedPhrases[] | undefined;
    private _timeouts;
    get timeouts(): DialogflowCxEntityTypeTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxEntityTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxEntityTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
