import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxIntentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#description DialogflowCxIntent#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the intent, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#display_name DialogflowCxIntent#display_name}
    */
    readonly displayName: string;
    /**
    * Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
  Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#is_fallback DialogflowCxIntent#is_fallback}
    */
    readonly isFallback?: boolean | cdktf.IResolvable;
    /**
    * The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
  Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#labels DialogflowCxIntent#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The language of the following fields in intent:
  Intent.training_phrases.parts.text
  If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#language_code DialogflowCxIntent#language_code}
    */
    readonly languageCode?: string;
    /**
    * The agent to create an intent for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#parent DialogflowCxIntent#parent}
    */
    readonly parent?: string;
    /**
    * The priority of this intent. Higher numbers represent higher priorities.
  If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
  If the supplied value is negative, the intent is ignored in runtime detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#priority DialogflowCxIntent#priority}
    */
    readonly priority?: number;
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#parameters DialogflowCxIntent#parameters}
    */
    readonly parameters?: DialogflowCxIntentParameters[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#timeouts DialogflowCxIntent#timeouts}
    */
    readonly timeouts?: DialogflowCxIntentTimeouts;
    /**
    * training_phrases block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#training_phrases DialogflowCxIntent#training_phrases}
    */
    readonly trainingPhrases?: DialogflowCxIntentTrainingPhrases[] | cdktf.IResolvable;
}
export interface DialogflowCxIntentParameters {
    /**
    * The entity type of the parameter.
  Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#entity_type DialogflowCxIntent#entity_type}
    */
    readonly entityType: string;
    /**
    * The unique identifier of the parameter. This field is used by training phrases to annotate their parts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#id DialogflowCxIntent#id}
    */
    readonly id: string;
    /**
    * Indicates whether the parameter represents a list of values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#is_list DialogflowCxIntent#is_list}
    */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging.
  Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#redact DialogflowCxIntent#redact}
    */
    readonly redact?: boolean | cdktf.IResolvable;
}
export declare function dialogflowCxIntentParametersToTerraform(struct?: DialogflowCxIntentParameters | cdktf.IResolvable): any;
export interface DialogflowCxIntentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#create DialogflowCxIntent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#delete DialogflowCxIntent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#update DialogflowCxIntent#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxIntentTimeoutsToTerraform(struct?: DialogflowCxIntentTimeoutsOutputReference | DialogflowCxIntentTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxIntentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxIntentTimeouts | undefined;
    set internalValue(value: DialogflowCxIntentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DialogflowCxIntentTrainingPhrasesParts {
    /**
    * The parameter used to annotate this part of the training phrase. This field is required for annotated parts of the training phrase.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#parameter_id DialogflowCxIntent#parameter_id}
    */
    readonly parameterId?: string;
    /**
    * The text for this part.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#text DialogflowCxIntent#text}
    */
    readonly text: string;
}
export declare function dialogflowCxIntentTrainingPhrasesPartsToTerraform(struct?: DialogflowCxIntentTrainingPhrasesParts | cdktf.IResolvable): any;
export interface DialogflowCxIntentTrainingPhrases {
    /**
    * Indicates how many times this example was added to the intent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#repeat_count DialogflowCxIntent#repeat_count}
    */
    readonly repeatCount?: number;
    /**
    * parts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent#parts DialogflowCxIntent#parts}
    */
    readonly parts: DialogflowCxIntentTrainingPhrasesParts[] | cdktf.IResolvable;
}
export declare function dialogflowCxIntentTrainingPhrasesToTerraform(struct?: DialogflowCxIntentTrainingPhrases | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent google_dialogflow_cx_intent}
*/
export declare class DialogflowCxIntent extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent google_dialogflow_cx_intent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxIntentConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxIntentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _isFallback?;
    get isFallback(): boolean | cdktf.IResolvable;
    set isFallback(value: boolean | cdktf.IResolvable);
    resetIsFallback(): void;
    get isFallbackInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _parameters?;
    get parameters(): DialogflowCxIntentParameters[] | cdktf.IResolvable;
    set parameters(value: DialogflowCxIntentParameters[] | cdktf.IResolvable);
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | DialogflowCxIntentParameters[] | undefined;
    private _timeouts;
    get timeouts(): DialogflowCxIntentTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxIntentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxIntentTimeouts | undefined;
    private _trainingPhrases?;
    get trainingPhrases(): DialogflowCxIntentTrainingPhrases[] | cdktf.IResolvable;
    set trainingPhrases(value: DialogflowCxIntentTrainingPhrases[] | cdktf.IResolvable);
    resetTrainingPhrases(): void;
    get trainingPhrasesInput(): cdktf.IResolvable | DialogflowCxIntentTrainingPhrases[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
