import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxPageConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable name of the page, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#display_name DialogflowCxPage#display_name}
    */
    readonly displayName: string;
    /**
    * The language of the following fields in page:
  
  Page.entry_fulfillment.messages
  Page.entry_fulfillment.conditional_cases
  Page.event_handlers.trigger_fulfillment.messages
  Page.event_handlers.trigger_fulfillment.conditional_cases
  Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
  Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
  Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
  Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
  Page.transition_routes.trigger_fulfillment.messages
  Page.transition_routes.trigger_fulfillment.conditional_cases
  If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#language_code DialogflowCxPage#language_code}
    */
    readonly languageCode?: string;
    /**
    * The flow to create a page for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#parent DialogflowCxPage#parent}
    */
    readonly parent?: string;
    /**
    * Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
  If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes.
  If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
  Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#transition_route_groups DialogflowCxPage#transition_route_groups}
    */
    readonly transitionRouteGroups?: string[];
    /**
    * entry_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#entry_fulfillment DialogflowCxPage#entry_fulfillment}
    */
    readonly entryFulfillment?: DialogflowCxPageEntryFulfillment;
    /**
    * event_handlers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#event_handlers DialogflowCxPage#event_handlers}
    */
    readonly eventHandlers?: DialogflowCxPageEventHandlers[] | cdktf.IResolvable;
    /**
    * form block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#form DialogflowCxPage#form}
    */
    readonly form?: DialogflowCxPageForm;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#timeouts DialogflowCxPage#timeouts}
    */
    readonly timeouts?: DialogflowCxPageTimeouts;
    /**
    * transition_routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#transition_routes DialogflowCxPage#transition_routes}
    */
    readonly transitionRoutes?: DialogflowCxPageTransitionRoutes[] | cdktf.IResolvable;
}
export interface DialogflowCxPageEntryFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function dialogflowCxPageEntryFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageEntryFulfillmentMessagesTextOutputReference | DialogflowCxPageEntryFulfillmentMessagesText): any;
export declare class DialogflowCxPageEntryFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageEntryFulfillmentMessagesText | undefined;
    set internalValue(value: DialogflowCxPageEntryFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageEntryFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: DialogflowCxPageEntryFulfillmentMessagesText;
}
export declare function dialogflowCxPageEntryFulfillmentMessagesToTerraform(struct?: DialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable): any;
export interface DialogflowCxPageEntryFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#return_partial_responses DialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#tag DialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#webhook DialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#messages DialogflowCxPage#messages}
    */
    readonly messages?: DialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxPageEntryFulfillmentToTerraform(struct?: DialogflowCxPageEntryFulfillmentOutputReference | DialogflowCxPageEntryFulfillment): any;
export declare class DialogflowCxPageEntryFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageEntryFulfillment | undefined;
    set internalValue(value: DialogflowCxPageEntryFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable;
    set messages(value: DialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable);
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | DialogflowCxPageEntryFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function dialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference | DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText): any;
export declare class DialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageEventHandlersTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxPageEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export interface DialogflowCxPageEventHandlersTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#return_partial_responses DialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#tag DialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#webhook DialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#messages DialogflowCxPage#messages}
    */
    readonly messages?: DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxPageEventHandlersTriggerFulfillmentToTerraform(struct?: DialogflowCxPageEventHandlersTriggerFulfillmentOutputReference | DialogflowCxPageEventHandlersTriggerFulfillment): any;
export declare class DialogflowCxPageEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageEventHandlersTriggerFulfillment | undefined;
    set internalValue(value: DialogflowCxPageEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    set messages(value: DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable);
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageEventHandlers {
    /**
    * The name of the event to handle.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#event DialogflowCxPage#event}
    */
    readonly event?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#target_flow DialogflowCxPage#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#target_page DialogflowCxPage#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#trigger_fulfillment DialogflowCxPage#trigger_fulfillment}
    */
    readonly triggerFulfillment?: DialogflowCxPageEventHandlersTriggerFulfillment;
}
export declare function dialogflowCxPageEventHandlersToTerraform(struct?: DialogflowCxPageEventHandlers | cdktf.IResolvable): any;
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function dialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference | DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText): any;
export declare class DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined;
    set internalValue(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText;
}
export declare function dialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable): any;
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#return_partial_responses DialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#tag DialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#webhook DialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#messages DialogflowCxPage#messages}
    */
    readonly messages?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference | DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): any;
export declare class DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
    set internalValue(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable;
    set messages(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable);
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageFormParametersFillBehavior {
    /**
    * initial_prompt_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#initial_prompt_fulfillment DialogflowCxPage#initial_prompt_fulfillment}
    */
    readonly initialPromptFulfillment?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment;
}
export declare function dialogflowCxPageFormParametersFillBehaviorToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorOutputReference | DialogflowCxPageFormParametersFillBehavior): any;
export declare class DialogflowCxPageFormParametersFillBehaviorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageFormParametersFillBehavior | undefined;
    set internalValue(value: DialogflowCxPageFormParametersFillBehavior | undefined);
    private _initialPromptFulfillment;
    get initialPromptFulfillment(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference;
    putInitialPromptFulfillment(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): void;
    resetInitialPromptFulfillment(): void;
    get initialPromptFulfillmentInput(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
}
export interface DialogflowCxPageFormParameters {
    /**
    * The human-readable name of the parameter, unique within the form.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#display_name DialogflowCxPage#display_name}
    */
    readonly displayName?: string;
    /**
    * The entity type of the parameter.
  Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#entity_type DialogflowCxPage#entity_type}
    */
    readonly entityType?: string;
    /**
    * Indicates whether the parameter represents a list of values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#is_list DialogflowCxPage#is_list}
    */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter content should be redacted in log.
  If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#redact DialogflowCxPage#redact}
    */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them.
  Required parameters must be filled before form filling concludes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#required DialogflowCxPage#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * fill_behavior block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#fill_behavior DialogflowCxPage#fill_behavior}
    */
    readonly fillBehavior?: DialogflowCxPageFormParametersFillBehavior;
}
export declare function dialogflowCxPageFormParametersToTerraform(struct?: DialogflowCxPageFormParameters | cdktf.IResolvable): any;
export interface DialogflowCxPageForm {
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#parameters DialogflowCxPage#parameters}
    */
    readonly parameters?: DialogflowCxPageFormParameters[] | cdktf.IResolvable;
}
export declare function dialogflowCxPageFormToTerraform(struct?: DialogflowCxPageFormOutputReference | DialogflowCxPageForm): any;
export declare class DialogflowCxPageFormOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageForm | undefined;
    set internalValue(value: DialogflowCxPageForm | undefined);
    private _parameters?;
    get parameters(): DialogflowCxPageFormParameters[] | cdktf.IResolvable;
    set parameters(value: DialogflowCxPageFormParameters[] | cdktf.IResolvable);
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | DialogflowCxPageFormParameters[] | undefined;
}
export interface DialogflowCxPageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#create DialogflowCxPage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#delete DialogflowCxPage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#update DialogflowCxPage#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxPageTimeoutsToTerraform(struct?: DialogflowCxPageTimeoutsOutputReference | DialogflowCxPageTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxPageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageTimeouts | undefined;
    set internalValue(value: DialogflowCxPageTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function dialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare class DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#text DialogflowCxPage#text}
    */
    readonly text?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export interface DialogflowCxPageTransitionRoutesTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#return_partial_responses DialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#tag DialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#webhook DialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#messages DialogflowCxPage#messages}
    */
    readonly messages?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxPageTransitionRoutesTriggerFulfillmentToTerraform(struct?: DialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference | DialogflowCxPageTransitionRoutesTriggerFulfillment): any;
export declare class DialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxPageTransitionRoutesTriggerFulfillment | undefined;
    set internalValue(value: DialogflowCxPageTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    set messages(value: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable);
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageTransitionRoutes {
    /**
    * The condition to evaluate against form parameters or session parameters.
  At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#condition DialogflowCxPage#condition}
    */
    readonly condition?: string;
    /**
    * The unique identifier of an Intent.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#intent DialogflowCxPage#intent}
    */
    readonly intent?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#target_flow DialogflowCxPage#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#target_page DialogflowCxPage#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page#trigger_fulfillment DialogflowCxPage#trigger_fulfillment}
    */
    readonly triggerFulfillment?: DialogflowCxPageTransitionRoutesTriggerFulfillment;
}
export declare function dialogflowCxPageTransitionRoutesToTerraform(struct?: DialogflowCxPageTransitionRoutes | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page google_dialogflow_cx_page}
*/
export declare class DialogflowCxPage extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page google_dialogflow_cx_page} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxPageConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxPageConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[];
    set transitionRouteGroups(value: string[]);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _entryFulfillment;
    get entryFulfillment(): DialogflowCxPageEntryFulfillmentOutputReference;
    putEntryFulfillment(value: DialogflowCxPageEntryFulfillment): void;
    resetEntryFulfillment(): void;
    get entryFulfillmentInput(): DialogflowCxPageEntryFulfillment | undefined;
    private _eventHandlers?;
    get eventHandlers(): DialogflowCxPageEventHandlers[] | cdktf.IResolvable;
    set eventHandlers(value: DialogflowCxPageEventHandlers[] | cdktf.IResolvable);
    resetEventHandlers(): void;
    get eventHandlersInput(): cdktf.IResolvable | DialogflowCxPageEventHandlers[] | undefined;
    private _form;
    get form(): DialogflowCxPageFormOutputReference;
    putForm(value: DialogflowCxPageForm): void;
    resetForm(): void;
    get formInput(): DialogflowCxPageForm | undefined;
    private _timeouts;
    get timeouts(): DialogflowCxPageTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxPageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxPageTimeouts | undefined;
    private _transitionRoutes?;
    get transitionRoutes(): DialogflowCxPageTransitionRoutes[] | cdktf.IResolvable;
    set transitionRoutes(value: DialogflowCxPageTransitionRoutes[] | cdktf.IResolvable);
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): cdktf.IResolvable | DialogflowCxPageTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
