import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version#description DialogflowCxVersion#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the version. Limit of 64 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version#display_name DialogflowCxVersion#display_name}
    */
    readonly displayName: string;
    /**
    * The Flow to create an Version for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version#parent DialogflowCxVersion#parent}
    */
    readonly parent?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version#timeouts DialogflowCxVersion#timeouts}
    */
    readonly timeouts?: DialogflowCxVersionTimeouts;
}
export declare class DialogflowCxVersionNluSettings extends cdktf.ComplexComputedList {
    get classificationThreshold(): number;
    get modelTrainingMode(): string;
    get modelType(): string;
}
export interface DialogflowCxVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version#create DialogflowCxVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version#delete DialogflowCxVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version#update DialogflowCxVersion#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxVersionTimeoutsToTerraform(struct?: DialogflowCxVersionTimeoutsOutputReference | DialogflowCxVersionTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DialogflowCxVersionTimeouts | undefined;
    set internalValue(value: DialogflowCxVersionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version google_dialogflow_cx_version}
*/
export declare class DialogflowCxVersion extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_version google_dialogflow_cx_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxVersionConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxVersionConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    nluSettings(index: string): DialogflowCxVersionNluSettings;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): DialogflowCxVersionTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
