import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EndpointsServiceIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_policy#policy_data EndpointsServiceIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_policy#service_name EndpointsServiceIamPolicy#service_name}
    */
    readonly serviceName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_policy google_endpoints_service_iam_policy}
*/
export declare class EndpointsServiceIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_policy google_endpoints_service_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EndpointsServiceIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: EndpointsServiceIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
