import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirestoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * The collection being indexed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#collection FirestoreIndex#collection}
    */
    readonly collection: string;
    /**
    * The Firestore database id. Defaults to '"(default)"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#database FirestoreIndex#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#project FirestoreIndex#project}
    */
    readonly project?: string;
    /**
    * The scope at which a query is run. Default value: "COLLECTION" Possible values: ["COLLECTION", "COLLECTION_GROUP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#query_scope FirestoreIndex#query_scope}
    */
    readonly queryScope?: string;
    /**
    * fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#fields FirestoreIndex#fields}
    */
    readonly fields: FirestoreIndexFields[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#timeouts FirestoreIndex#timeouts}
    */
    readonly timeouts?: FirestoreIndexTimeouts;
}
export interface FirestoreIndexFields {
    /**
    * Indicates that this field supports operations on arrayValues. Only one of 'order' and 'arrayConfig' can
  be specified. Possible values: ["CONTAINS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#array_config FirestoreIndex#array_config}
    */
    readonly arrayConfig?: string;
    /**
    * Name of the field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#field_path FirestoreIndex#field_path}
    */
    readonly fieldPath?: string;
    /**
    * Indicates that this field supports ordering by the specified order or comparing using =, <, <=, >, >=.
  Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["ASCENDING", "DESCENDING"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#order FirestoreIndex#order}
    */
    readonly order?: string;
}
export declare function firestoreIndexFieldsToTerraform(struct?: FirestoreIndexFields | cdktf.IResolvable): any;
export interface FirestoreIndexTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#create FirestoreIndex#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#delete FirestoreIndex#delete}
    */
    readonly delete?: string;
}
export declare function firestoreIndexTimeoutsToTerraform(struct?: FirestoreIndexTimeoutsOutputReference | FirestoreIndexTimeouts | cdktf.IResolvable): any;
export declare class FirestoreIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FirestoreIndexTimeouts | undefined;
    set internalValue(value: FirestoreIndexTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/firestore_index google_firestore_index}
*/
export declare class FirestoreIndex extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/firestore_index google_firestore_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirestoreIndexConfig
    */
    constructor(scope: Construct, id: string, config: FirestoreIndexConfig);
    private _collection?;
    get collection(): string;
    set collection(value: string);
    get collectionInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _queryScope?;
    get queryScope(): string;
    set queryScope(value: string);
    resetQueryScope(): void;
    get queryScopeInput(): string | undefined;
    private _fields?;
    get fields(): FirestoreIndexFields[] | cdktf.IResolvable;
    set fields(value: FirestoreIndexFields[] | cdktf.IResolvable);
    get fieldsInput(): cdktf.IResolvable | FirestoreIndexFields[] | undefined;
    private _timeouts;
    get timeouts(): FirestoreIndexTimeoutsOutputReference;
    putTimeouts(value: FirestoreIndexTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirestoreIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
