import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GameServicesGameServerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. The resource name of the game server cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#cluster_id GameServicesGameServerCluster#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Human readable description of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#description GameServicesGameServerCluster#description}
    */
    readonly description?: string;
    /**
    * The labels associated with this game server cluster. Each label is a
  key-value pair.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#labels GameServicesGameServerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the Cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#location GameServicesGameServerCluster#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#project GameServicesGameServerCluster#project}
    */
    readonly project?: string;
    /**
    * The realm id of the game server realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#realm_id GameServicesGameServerCluster#realm_id}
    */
    readonly realmId: string;
    /**
    * connection_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#connection_info GameServicesGameServerCluster#connection_info}
    */
    readonly connectionInfo: GameServicesGameServerClusterConnectionInfo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#timeouts GameServicesGameServerCluster#timeouts}
    */
    readonly timeouts?: GameServicesGameServerClusterTimeouts;
}
export interface GameServicesGameServerClusterConnectionInfoGkeClusterReference {
    /**
    * The full or partial name of a GKE cluster, using one of the following
  forms:
  
  * 'projects/{project_id}/locations/{location}/clusters/{cluster_id}'
  * 'locations/{location}/clusters/{cluster_id}'
  * '{cluster_id}'
  
  If project and location are not specified, the project and location of the
  GameServerCluster resource are used to generate the full name of the
  GKE cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#cluster GameServicesGameServerCluster#cluster}
    */
    readonly cluster: string;
}
export declare function gameServicesGameServerClusterConnectionInfoGkeClusterReferenceToTerraform(struct?: GameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference | GameServicesGameServerClusterConnectionInfoGkeClusterReference): any;
export declare class GameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): GameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined;
    set internalValue(value: GameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
}
export interface GameServicesGameServerClusterConnectionInfo {
    /**
    * Namespace designated on the game server cluster where the game server
  instances will be created. The namespace existence will be validated
  during creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#namespace GameServicesGameServerCluster#namespace}
    */
    readonly namespace: string;
    /**
    * gke_cluster_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#gke_cluster_reference GameServicesGameServerCluster#gke_cluster_reference}
    */
    readonly gkeClusterReference: GameServicesGameServerClusterConnectionInfoGkeClusterReference;
}
export declare function gameServicesGameServerClusterConnectionInfoToTerraform(struct?: GameServicesGameServerClusterConnectionInfoOutputReference | GameServicesGameServerClusterConnectionInfo): any;
export declare class GameServicesGameServerClusterConnectionInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): GameServicesGameServerClusterConnectionInfo | undefined;
    set internalValue(value: GameServicesGameServerClusterConnectionInfo | undefined);
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _gkeClusterReference;
    get gkeClusterReference(): GameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference;
    putGkeClusterReference(value: GameServicesGameServerClusterConnectionInfoGkeClusterReference): void;
    get gkeClusterReferenceInput(): GameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined;
}
export interface GameServicesGameServerClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#create GameServicesGameServerCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#delete GameServicesGameServerCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#update GameServicesGameServerCluster#update}
    */
    readonly update?: string;
}
export declare function gameServicesGameServerClusterTimeoutsToTerraform(struct?: GameServicesGameServerClusterTimeoutsOutputReference | GameServicesGameServerClusterTimeouts | cdktf.IResolvable): any;
export declare class GameServicesGameServerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): GameServicesGameServerClusterTimeouts | undefined;
    set internalValue(value: GameServicesGameServerClusterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster google_game_services_game_server_cluster}
*/
export declare class GameServicesGameServerCluster extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster google_game_services_game_server_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GameServicesGameServerClusterConfig
    */
    constructor(scope: Construct, id: string, config: GameServicesGameServerClusterConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _realmId?;
    get realmId(): string;
    set realmId(value: string);
    get realmIdInput(): string | undefined;
    private _connectionInfo;
    get connectionInfo(): GameServicesGameServerClusterConnectionInfoOutputReference;
    putConnectionInfo(value: GameServicesGameServerClusterConnectionInfo): void;
    get connectionInfoInput(): GameServicesGameServerClusterConnectionInfo | undefined;
    private _timeouts;
    get timeouts(): GameServicesGameServerClusterTimeoutsOutputReference;
    putTimeouts(value: GameServicesGameServerClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GameServicesGameServerClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
