import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GameServicesGameServerDeploymentRolloutConfig extends cdktf.TerraformMetaArguments {
    /**
    * This field points to the game server config that is
  applied by default to all realms and clusters. For example,
  
  'projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#default_game_server_config GameServicesGameServerDeploymentRollout#default_game_server_config}
    */
    readonly defaultGameServerConfig: string;
    /**
    * The deployment to rollout the new config to. Only 1 rollout must be associated with each deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#deployment_id GameServicesGameServerDeploymentRollout#deployment_id}
    */
    readonly deploymentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#project GameServicesGameServerDeploymentRollout#project}
    */
    readonly project?: string;
    /**
    * game_server_config_overrides block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#game_server_config_overrides GameServicesGameServerDeploymentRollout#game_server_config_overrides}
    */
    readonly gameServerConfigOverrides?: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#timeouts GameServicesGameServerDeploymentRollout#timeouts}
    */
    readonly timeouts?: GameServicesGameServerDeploymentRolloutTimeouts;
}
export interface GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector {
    /**
    * List of realms to match against.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#realms GameServicesGameServerDeploymentRollout#realms}
    */
    readonly realms?: string[];
}
export declare function gameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorToTerraform(struct?: GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference | GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector): any;
export declare class GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined;
    set internalValue(value: GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined);
    private _realms?;
    get realms(): string[];
    set realms(value: string[]);
    resetRealms(): void;
    get realmsInput(): string[] | undefined;
}
export interface GameServicesGameServerDeploymentRolloutGameServerConfigOverrides {
    /**
    * Version of the configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#config_version GameServicesGameServerDeploymentRollout#config_version}
    */
    readonly configVersion?: string;
    /**
    * realms_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#realms_selector GameServicesGameServerDeploymentRollout#realms_selector}
    */
    readonly realmsSelector?: GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector;
}
export declare function gameServicesGameServerDeploymentRolloutGameServerConfigOverridesToTerraform(struct?: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides | cdktf.IResolvable): any;
export interface GameServicesGameServerDeploymentRolloutTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#create GameServicesGameServerDeploymentRollout#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#delete GameServicesGameServerDeploymentRollout#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#update GameServicesGameServerDeploymentRollout#update}
    */
    readonly update?: string;
}
export declare function gameServicesGameServerDeploymentRolloutTimeoutsToTerraform(struct?: GameServicesGameServerDeploymentRolloutTimeoutsOutputReference | GameServicesGameServerDeploymentRolloutTimeouts | cdktf.IResolvable): any;
export declare class GameServicesGameServerDeploymentRolloutTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): GameServicesGameServerDeploymentRolloutTimeouts | undefined;
    set internalValue(value: GameServicesGameServerDeploymentRolloutTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout}
*/
export declare class GameServicesGameServerDeploymentRollout extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GameServicesGameServerDeploymentRolloutConfig
    */
    constructor(scope: Construct, id: string, config: GameServicesGameServerDeploymentRolloutConfig);
    private _defaultGameServerConfig?;
    get defaultGameServerConfig(): string;
    set defaultGameServerConfig(value: string);
    get defaultGameServerConfigInput(): string | undefined;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _gameServerConfigOverrides?;
    get gameServerConfigOverrides(): GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | cdktf.IResolvable;
    set gameServerConfigOverrides(value: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | cdktf.IResolvable);
    resetGameServerConfigOverrides(): void;
    get gameServerConfigOverridesInput(): cdktf.IResolvable | GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | undefined;
    private _timeouts;
    get timeouts(): GameServicesGameServerDeploymentRolloutTimeoutsOutputReference;
    putTimeouts(value: GameServicesGameServerDeploymentRolloutTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GameServicesGameServerDeploymentRolloutTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
