import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GameServicesRealmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human readable description of the realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#description GameServicesRealm#description}
    */
    readonly description?: string;
    /**
    * The labels associated with this realm. Each label is a key-value pair.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#labels GameServicesRealm#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the Realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#location GameServicesRealm#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#project GameServicesRealm#project}
    */
    readonly project?: string;
    /**
    * GCP region of the Realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#realm_id GameServicesRealm#realm_id}
    */
    readonly realmId: string;
    /**
    * Required. Time zone where all realm-specific policies are evaluated. The value of
  this field must be from the IANA time zone database:
  https://www.iana.org/time-zones.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#time_zone GameServicesRealm#time_zone}
    */
    readonly timeZone: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#timeouts GameServicesRealm#timeouts}
    */
    readonly timeouts?: GameServicesRealmTimeouts;
}
export interface GameServicesRealmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#create GameServicesRealm#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#delete GameServicesRealm#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm#update GameServicesRealm#update}
    */
    readonly update?: string;
}
export declare function gameServicesRealmTimeoutsToTerraform(struct?: GameServicesRealmTimeoutsOutputReference | GameServicesRealmTimeouts | cdktf.IResolvable): any;
export declare class GameServicesRealmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): GameServicesRealmTimeouts | undefined;
    set internalValue(value: GameServicesRealmTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_realm google_game_services_realm}
*/
export declare class GameServicesRealm extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_realm google_game_services_realm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GameServicesRealmConfig
    */
    constructor(scope: Construct, id: string, config: GameServicesRealmConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _realmId?;
    get realmId(): string;
    set realmId(value: string);
    get realmIdInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): GameServicesRealmTimeoutsOutputReference;
    putTimeouts(value: GameServicesRealmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GameServicesRealmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
