import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareDicomStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the dataset addressed by this request. Must be in the format
  'projects/{project}/locations/{location}/datasets/{dataset}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#dataset HealthcareDicomStore#dataset}
    */
    readonly dataset: string;
    /**
    * User-supplied key-value pairs used to organize DICOM stores.
  
  Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
  conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
  
  Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
  bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
  
  No more than 64 labels can be associated with a given store.
  
  An object containing a list of "key": value pairs.
  Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#labels HealthcareDicomStore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name for the DicomStore.
  
  ** Changing this property may recreate the Dicom store (removing all data) **
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#name HealthcareDicomStore#name}
    */
    readonly name: string;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#notification_config HealthcareDicomStore#notification_config}
    */
    readonly notificationConfig?: HealthcareDicomStoreNotificationConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#timeouts HealthcareDicomStore#timeouts}
    */
    readonly timeouts?: HealthcareDicomStoreTimeouts;
}
export interface HealthcareDicomStoreNotificationConfig {
    /**
    * The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
  PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
  It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
  was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
  project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
  Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#pubsub_topic HealthcareDicomStore#pubsub_topic}
    */
    readonly pubsubTopic: string;
}
export declare function healthcareDicomStoreNotificationConfigToTerraform(struct?: HealthcareDicomStoreNotificationConfigOutputReference | HealthcareDicomStoreNotificationConfig): any;
export declare class HealthcareDicomStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HealthcareDicomStoreNotificationConfig | undefined;
    set internalValue(value: HealthcareDicomStoreNotificationConfig | undefined);
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
}
export interface HealthcareDicomStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#create HealthcareDicomStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#delete HealthcareDicomStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store#update HealthcareDicomStore#update}
    */
    readonly update?: string;
}
export declare function healthcareDicomStoreTimeoutsToTerraform(struct?: HealthcareDicomStoreTimeoutsOutputReference | HealthcareDicomStoreTimeouts | cdktf.IResolvable): any;
export declare class HealthcareDicomStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HealthcareDicomStoreTimeouts | undefined;
    set internalValue(value: HealthcareDicomStoreTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store google_healthcare_dicom_store}
*/
export declare class HealthcareDicomStore extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store google_healthcare_dicom_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareDicomStoreConfig
    */
    constructor(scope: Construct, id: string, config: HealthcareDicomStoreConfig);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get selfLink(): string;
    private _notificationConfig;
    get notificationConfig(): HealthcareDicomStoreNotificationConfigOutputReference;
    putNotificationConfig(value: HealthcareDicomStoreNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): HealthcareDicomStoreNotificationConfig | undefined;
    private _timeouts;
    get timeouts(): HealthcareDicomStoreTimeoutsOutputReference;
    putTimeouts(value: HealthcareDicomStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): HealthcareDicomStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
