import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapAppEngineServiceIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#app_id IapAppEngineServiceIamBinding#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#members IapAppEngineServiceIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#project IapAppEngineServiceIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#role IapAppEngineServiceIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#service IapAppEngineServiceIamBinding#service}
    */
    readonly service: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#condition IapAppEngineServiceIamBinding#condition}
    */
    readonly condition?: IapAppEngineServiceIamBindingCondition;
}
export interface IapAppEngineServiceIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#description IapAppEngineServiceIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#expression IapAppEngineServiceIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding#title IapAppEngineServiceIamBinding#title}
    */
    readonly title: string;
}
export declare function iapAppEngineServiceIamBindingConditionToTerraform(struct?: IapAppEngineServiceIamBindingConditionOutputReference | IapAppEngineServiceIamBindingCondition): any;
export declare class IapAppEngineServiceIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IapAppEngineServiceIamBindingCondition | undefined;
    set internalValue(value: IapAppEngineServiceIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding google_iap_app_engine_service_iam_binding}
*/
export declare class IapAppEngineServiceIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_binding google_iap_app_engine_service_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapAppEngineServiceIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: IapAppEngineServiceIamBindingConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _condition;
    get condition(): IapAppEngineServiceIamBindingConditionOutputReference;
    putCondition(value: IapAppEngineServiceIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): IapAppEngineServiceIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
