import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier of the brand to which this client
  is attached to. The format is
  'projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client#brand IapClient#brand}
    */
    readonly brand: string;
    /**
    * Human-friendly name given to the OAuth client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client#display_name IapClient#display_name}
    */
    readonly displayName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client#timeouts IapClient#timeouts}
    */
    readonly timeouts?: IapClientTimeouts;
}
export interface IapClientTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client#create IapClient#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client#delete IapClient#delete}
    */
    readonly delete?: string;
}
export declare function iapClientTimeoutsToTerraform(struct?: IapClientTimeoutsOutputReference | IapClientTimeouts | cdktf.IResolvable): any;
export declare class IapClientTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IapClientTimeouts | undefined;
    set internalValue(value: IapClientTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_client google_iap_client}
*/
export declare class IapClient extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_client google_iap_client} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapClientConfig
    */
    constructor(scope: Construct, id: string, config: IapClientConfig);
    private _brand?;
    get brand(): string;
    set brand(value: string);
    get brandInput(): string | undefined;
    get clientId(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    get secret(): string;
    private _timeouts;
    get timeouts(): IapClientTimeoutsOutputReference;
    putTimeouts(value: IapClientTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IapClientTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
