import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformDefaultSupportedIdpConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * OAuth client ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#client_id IdentityPlatformDefaultSupportedIdpConfig#client_id}
    */
    readonly clientId: string;
    /**
    * OAuth client secret
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#client_secret IdentityPlatformDefaultSupportedIdpConfig#client_secret}
    */
    readonly clientSecret: string;
    /**
    * If this IDP allows the user to sign in
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#enabled IdentityPlatformDefaultSupportedIdpConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * ID of the IDP. Possible values include:
  
  * 'apple.com'
  
  * 'facebook.com'
  
  * 'gc.apple.com'
  
  * 'github.com'
  
  * 'google.com'
  
  * 'linkedin.com'
  
  * 'microsoft.com'
  
  * 'playgames.google.com'
  
  * 'twitter.com'
  
  * 'yahoo.com'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#idp_id IdentityPlatformDefaultSupportedIdpConfig#idp_id}
    */
    readonly idpId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#project IdentityPlatformDefaultSupportedIdpConfig#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#timeouts IdentityPlatformDefaultSupportedIdpConfig#timeouts}
    */
    readonly timeouts?: IdentityPlatformDefaultSupportedIdpConfigTimeouts;
}
export interface IdentityPlatformDefaultSupportedIdpConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#create IdentityPlatformDefaultSupportedIdpConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#delete IdentityPlatformDefaultSupportedIdpConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config#update IdentityPlatformDefaultSupportedIdpConfig#update}
    */
    readonly update?: string;
}
export declare function identityPlatformDefaultSupportedIdpConfigTimeoutsToTerraform(struct?: IdentityPlatformDefaultSupportedIdpConfigTimeoutsOutputReference | IdentityPlatformDefaultSupportedIdpConfigTimeouts | cdktf.IResolvable): any;
export declare class IdentityPlatformDefaultSupportedIdpConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IdentityPlatformDefaultSupportedIdpConfigTimeouts | undefined;
    set internalValue(value: IdentityPlatformDefaultSupportedIdpConfigTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config google_identity_platform_default_supported_idp_config}
*/
export declare class IdentityPlatformDefaultSupportedIdpConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config google_identity_platform_default_supported_idp_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityPlatformDefaultSupportedIdpConfigConfig
    */
    constructor(scope: Construct, id: string, config: IdentityPlatformDefaultSupportedIdpConfigConfig);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _idpId?;
    get idpId(): string;
    set idpId(value: string);
    get idpIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): IdentityPlatformDefaultSupportedIdpConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformDefaultSupportedIdpConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformDefaultSupportedIdpConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
