import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human friendly display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#display_name IdentityPlatformInboundSamlConfig#display_name}
    */
    readonly displayName: string;
    /**
    * If this config allows users to sign in with the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#enabled IdentityPlatformInboundSamlConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name of the InboundSamlConfig resource. Must start with 'saml.' and can only have alphanumeric characters,
  hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
  alphanumeric character, and have at least 2 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#name IdentityPlatformInboundSamlConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#project IdentityPlatformInboundSamlConfig#project}
    */
    readonly project?: string;
    /**
    * idp_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#idp_config IdentityPlatformInboundSamlConfig#idp_config}
    */
    readonly idpConfig: IdentityPlatformInboundSamlConfigIdpConfig;
    /**
    * sp_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sp_config IdentityPlatformInboundSamlConfig#sp_config}
    */
    readonly spConfig: IdentityPlatformInboundSamlConfigSpConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#timeouts IdentityPlatformInboundSamlConfig#timeouts}
    */
    readonly timeouts?: IdentityPlatformInboundSamlConfigTimeouts;
}
export interface IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates {
    /**
    * The IdP's x509 certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#x509_certificate IdentityPlatformInboundSamlConfig#x509_certificate}
    */
    readonly x509Certificate?: string;
}
export declare function identityPlatformInboundSamlConfigIdpConfigIdpCertificatesToTerraform(struct?: IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable): any;
export interface IdentityPlatformInboundSamlConfigIdpConfig {
    /**
    * Unique identifier for all SAML entities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#idp_entity_id IdentityPlatformInboundSamlConfig#idp_entity_id}
    */
    readonly idpEntityId: string;
    /**
    * Indicates if outbounding SAMLRequest should be signed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sign_request IdentityPlatformInboundSamlConfig#sign_request}
    */
    readonly signRequest?: boolean | cdktf.IResolvable;
    /**
    * URL to send Authentication request to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sso_url IdentityPlatformInboundSamlConfig#sso_url}
    */
    readonly ssoUrl: string;
    /**
    * idp_certificates block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#idp_certificates IdentityPlatformInboundSamlConfig#idp_certificates}
    */
    readonly idpCertificates: IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
}
export declare function identityPlatformInboundSamlConfigIdpConfigToTerraform(struct?: IdentityPlatformInboundSamlConfigIdpConfigOutputReference | IdentityPlatformInboundSamlConfigIdpConfig): any;
export declare class IdentityPlatformInboundSamlConfigIdpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IdentityPlatformInboundSamlConfigIdpConfig | undefined;
    set internalValue(value: IdentityPlatformInboundSamlConfigIdpConfig | undefined);
    private _idpEntityId?;
    get idpEntityId(): string;
    set idpEntityId(value: string);
    get idpEntityIdInput(): string | undefined;
    private _signRequest?;
    get signRequest(): boolean | cdktf.IResolvable;
    set signRequest(value: boolean | cdktf.IResolvable);
    resetSignRequest(): void;
    get signRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _idpCertificates?;
    get idpCertificates(): IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
    set idpCertificates(value: IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable);
    get idpCertificatesInput(): cdktf.IResolvable | IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | undefined;
}
export declare class IdentityPlatformInboundSamlConfigSpConfigSpCertificates extends cdktf.ComplexComputedList {
    get x509Certificate(): string;
}
export interface IdentityPlatformInboundSamlConfigSpConfig {
    /**
    * Callback URI where responses from IDP are handled. Must start with 'https://'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#callback_uri IdentityPlatformInboundSamlConfig#callback_uri}
    */
    readonly callbackUri?: string;
    /**
    * Unique identifier for all SAML entities.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sp_entity_id IdentityPlatformInboundSamlConfig#sp_entity_id}
    */
    readonly spEntityId?: string;
}
export declare function identityPlatformInboundSamlConfigSpConfigToTerraform(struct?: IdentityPlatformInboundSamlConfigSpConfigOutputReference | IdentityPlatformInboundSamlConfigSpConfig): any;
export declare class IdentityPlatformInboundSamlConfigSpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IdentityPlatformInboundSamlConfigSpConfig | undefined;
    set internalValue(value: IdentityPlatformInboundSamlConfigSpConfig | undefined);
    private _callbackUri?;
    get callbackUri(): string;
    set callbackUri(value: string);
    resetCallbackUri(): void;
    get callbackUriInput(): string | undefined;
    spCertificates(index: string): IdentityPlatformInboundSamlConfigSpConfigSpCertificates;
    private _spEntityId?;
    get spEntityId(): string;
    set spEntityId(value: string);
    resetSpEntityId(): void;
    get spEntityIdInput(): string | undefined;
}
export interface IdentityPlatformInboundSamlConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#create IdentityPlatformInboundSamlConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#delete IdentityPlatformInboundSamlConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#update IdentityPlatformInboundSamlConfig#update}
    */
    readonly update?: string;
}
export declare function identityPlatformInboundSamlConfigTimeoutsToTerraform(struct?: IdentityPlatformInboundSamlConfigTimeoutsOutputReference | IdentityPlatformInboundSamlConfigTimeouts | cdktf.IResolvable): any;
export declare class IdentityPlatformInboundSamlConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IdentityPlatformInboundSamlConfigTimeouts | undefined;
    set internalValue(value: IdentityPlatformInboundSamlConfigTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config google_identity_platform_inbound_saml_config}
*/
export declare class IdentityPlatformInboundSamlConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config google_identity_platform_inbound_saml_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityPlatformInboundSamlConfigConfig
    */
    constructor(scope: Construct, id: string, config: IdentityPlatformInboundSamlConfigConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _idpConfig;
    get idpConfig(): IdentityPlatformInboundSamlConfigIdpConfigOutputReference;
    putIdpConfig(value: IdentityPlatformInboundSamlConfigIdpConfig): void;
    get idpConfigInput(): IdentityPlatformInboundSamlConfigIdpConfig | undefined;
    private _spConfig;
    get spConfig(): IdentityPlatformInboundSamlConfigSpConfigOutputReference;
    putSpConfig(value: IdentityPlatformInboundSamlConfigSpConfig): void;
    get spConfigInput(): IdentityPlatformInboundSamlConfigSpConfig | undefined;
    private _timeouts;
    get timeouts(): IdentityPlatformInboundSamlConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformInboundSamlConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformInboundSamlConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
