import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsKeyRingIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member#key_ring_id KmsKeyRingIamMember#key_ring_id}
    */
    readonly keyRingId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member#member KmsKeyRingIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member#role KmsKeyRingIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member#condition KmsKeyRingIamMember#condition}
    */
    readonly condition?: KmsKeyRingIamMemberCondition;
}
export interface KmsKeyRingIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member#description KmsKeyRingIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member#expression KmsKeyRingIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member#title KmsKeyRingIamMember#title}
    */
    readonly title: string;
}
export declare function kmsKeyRingIamMemberConditionToTerraform(struct?: KmsKeyRingIamMemberConditionOutputReference | KmsKeyRingIamMemberCondition): any;
export declare class KmsKeyRingIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KmsKeyRingIamMemberCondition | undefined;
    set internalValue(value: KmsKeyRingIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member google_kms_key_ring_iam_member}
*/
export declare class KmsKeyRingIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_member google_kms_key_ring_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsKeyRingIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: KmsKeyRingIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _keyRingId?;
    get keyRingId(): string;
    set keyRingId(value: string);
    get keyRingIdInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): KmsKeyRingIamMemberConditionOutputReference;
    putCondition(value: KmsKeyRingIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): KmsKeyRingIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
