import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsKeyRingConfig extends cdktf.TerraformMetaArguments {
    /**
    * The location for the KeyRing.
  A full list of valid locations can be found by running 'gcloud kms locations list'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring#location KmsKeyRing#location}
    */
    readonly location: string;
    /**
    * The resource name for the KeyRing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring#name KmsKeyRing#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring#project KmsKeyRing#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring#timeouts KmsKeyRing#timeouts}
    */
    readonly timeouts?: KmsKeyRingTimeouts;
}
export interface KmsKeyRingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring#create KmsKeyRing#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring#delete KmsKeyRing#delete}
    */
    readonly delete?: string;
}
export declare function kmsKeyRingTimeoutsToTerraform(struct?: KmsKeyRingTimeoutsOutputReference | KmsKeyRingTimeouts | cdktf.IResolvable): any;
export declare class KmsKeyRingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KmsKeyRingTimeouts | undefined;
    set internalValue(value: KmsKeyRingTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring google_kms_key_ring}
*/
export declare class KmsKeyRing extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring google_kms_key_ring} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsKeyRingConfig
    */
    constructor(scope: Construct, id: string, config: KmsKeyRingConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): KmsKeyRingTimeoutsOutputReference;
    putTimeouts(value: KmsKeyRingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KmsKeyRingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
