import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringDashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * The JSON representation of a dashboard, following the format at https://cloud.google.com/monitoring/api/ref_v3/rest/v1/projects.dashboards.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard#dashboard_json MonitoringDashboard#dashboard_json}
    */
    readonly dashboardJson: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard#project MonitoringDashboard#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard#timeouts MonitoringDashboard#timeouts}
    */
    readonly timeouts?: MonitoringDashboardTimeouts;
}
export interface MonitoringDashboardTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard#create MonitoringDashboard#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard#delete MonitoringDashboard#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard#update MonitoringDashboard#update}
    */
    readonly update?: string;
}
export declare function monitoringDashboardTimeoutsToTerraform(struct?: MonitoringDashboardTimeoutsOutputReference | MonitoringDashboardTimeouts | cdktf.IResolvable): any;
export declare class MonitoringDashboardTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringDashboardTimeouts | undefined;
    set internalValue(value: MonitoringDashboardTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard google_monitoring_dashboard}
*/
export declare class MonitoringDashboard extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard google_monitoring_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringDashboardConfig
    */
    constructor(scope: Construct, id: string, config: MonitoringDashboardConfig);
    private _dashboardJson?;
    get dashboardJson(): string;
    set dashboardJson(value: string);
    get dashboardJsonInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): MonitoringDashboardTimeoutsOutputReference;
    putTimeouts(value: MonitoringDashboardTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringDashboardTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
