import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotebooksLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the Location resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_location#name NotebooksLocation#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_location#project NotebooksLocation#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_location#timeouts NotebooksLocation#timeouts}
    */
    readonly timeouts?: NotebooksLocationTimeouts;
}
export interface NotebooksLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_location#create NotebooksLocation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_location#delete NotebooksLocation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_location#update NotebooksLocation#update}
    */
    readonly update?: string;
}
export declare function notebooksLocationTimeoutsToTerraform(struct?: NotebooksLocationTimeoutsOutputReference | NotebooksLocationTimeouts | cdktf.IResolvable): any;
export declare class NotebooksLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NotebooksLocationTimeouts | undefined;
    set internalValue(value: NotebooksLocationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_location google_notebooks_location}
*/
export declare class NotebooksLocation extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_location google_notebooks_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotebooksLocationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: NotebooksLocationConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): NotebooksLocationTimeoutsOutputReference;
    putTimeouts(value: NotebooksLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NotebooksLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
