import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member#member OrganizationIamMember#member}
    */
    readonly member: string;
    /**
    * The numeric ID of the organization in which you want to manage the audit logging config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member#org_id OrganizationIamMember#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member#role OrganizationIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member#condition OrganizationIamMember#condition}
    */
    readonly condition?: OrganizationIamMemberCondition;
}
export interface OrganizationIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member#description OrganizationIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member#expression OrganizationIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member#title OrganizationIamMember#title}
    */
    readonly title: string;
}
export declare function organizationIamMemberConditionToTerraform(struct?: OrganizationIamMemberConditionOutputReference | OrganizationIamMemberCondition): any;
export declare class OrganizationIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): OrganizationIamMemberCondition | undefined;
    set internalValue(value: OrganizationIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member google_organization_iam_member}
*/
export declare class OrganizationIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_member google_organization_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): OrganizationIamMemberConditionOutputReference;
    putCondition(value: OrganizationIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): OrganizationIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
