import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#constraint OrganizationPolicy#constraint}
    */
    readonly constraint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#org_id OrganizationPolicy#org_id}
    */
    readonly orgId: string;
    /**
    * Version of the Policy. Default version is 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#version OrganizationPolicy#version}
    */
    readonly version?: number;
    /**
    * boolean_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#boolean_policy OrganizationPolicy#boolean_policy}
    */
    readonly booleanPolicy?: OrganizationPolicyBooleanPolicy;
    /**
    * list_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#list_policy OrganizationPolicy#list_policy}
    */
    readonly listPolicy?: OrganizationPolicyListPolicy;
    /**
    * restore_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#restore_policy OrganizationPolicy#restore_policy}
    */
    readonly restorePolicy?: OrganizationPolicyRestorePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#timeouts OrganizationPolicy#timeouts}
    */
    readonly timeouts?: OrganizationPolicyTimeouts;
}
export interface OrganizationPolicyBooleanPolicy {
    /**
    * If true, then the Policy is enforced. If false, then any configuration is acceptable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#enforced OrganizationPolicy#enforced}
    */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare function organizationPolicyBooleanPolicyToTerraform(struct?: OrganizationPolicyBooleanPolicyOutputReference | OrganizationPolicyBooleanPolicy): any;
export declare class OrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): OrganizationPolicyBooleanPolicy | undefined;
    set internalValue(value: OrganizationPolicyBooleanPolicy | undefined);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationPolicyListPolicyAllow {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#all OrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#values OrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function organizationPolicyListPolicyAllowToTerraform(struct?: OrganizationPolicyListPolicyAllowOutputReference | OrganizationPolicyListPolicyAllow): any;
export declare class OrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): OrganizationPolicyListPolicyAllow | undefined;
    set internalValue(value: OrganizationPolicyListPolicyAllow | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface OrganizationPolicyListPolicyDeny {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#all OrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#values OrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function organizationPolicyListPolicyDenyToTerraform(struct?: OrganizationPolicyListPolicyDenyOutputReference | OrganizationPolicyListPolicyDeny): any;
export declare class OrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): OrganizationPolicyListPolicyDeny | undefined;
    set internalValue(value: OrganizationPolicyListPolicyDeny | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface OrganizationPolicyListPolicy {
    /**
    * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#inherit_from_parent OrganizationPolicy#inherit_from_parent}
    */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#suggested_value OrganizationPolicy#suggested_value}
    */
    readonly suggestedValue?: string;
    /**
    * allow block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#allow OrganizationPolicy#allow}
    */
    readonly allow?: OrganizationPolicyListPolicyAllow;
    /**
    * deny block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#deny OrganizationPolicy#deny}
    */
    readonly deny?: OrganizationPolicyListPolicyDeny;
}
export declare function organizationPolicyListPolicyToTerraform(struct?: OrganizationPolicyListPolicyOutputReference | OrganizationPolicyListPolicy): any;
export declare class OrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): OrganizationPolicyListPolicy | undefined;
    set internalValue(value: OrganizationPolicyListPolicy | undefined);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable;
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string;
    set suggestedValue(value: string);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow;
    get allow(): OrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: OrganizationPolicyListPolicyAllow): void;
    resetAllow(): void;
    get allowInput(): OrganizationPolicyListPolicyAllow | undefined;
    private _deny;
    get deny(): OrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: OrganizationPolicyListPolicyDeny): void;
    resetDeny(): void;
    get denyInput(): OrganizationPolicyListPolicyDeny | undefined;
}
export interface OrganizationPolicyRestorePolicy {
    /**
    * May only be set to true. If set, then the default Policy is restored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#default OrganizationPolicy#default}
    */
    readonly default: boolean | cdktf.IResolvable;
}
export declare function organizationPolicyRestorePolicyToTerraform(struct?: OrganizationPolicyRestorePolicyOutputReference | OrganizationPolicyRestorePolicy): any;
export declare class OrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): OrganizationPolicyRestorePolicy | undefined;
    set internalValue(value: OrganizationPolicyRestorePolicy | undefined);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#create OrganizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#delete OrganizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#read OrganizationPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy#update OrganizationPolicy#update}
    */
    readonly update?: string;
}
export declare function organizationPolicyTimeoutsToTerraform(struct?: OrganizationPolicyTimeoutsOutputReference | OrganizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class OrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): OrganizationPolicyTimeouts | undefined;
    set internalValue(value: OrganizationPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_policy google_organization_policy}
*/
export declare class OrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_policy google_organization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy;
    get booleanPolicy(): OrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: OrganizationPolicyBooleanPolicy): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): OrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy;
    get listPolicy(): OrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: OrganizationPolicyListPolicy): void;
    resetListPolicy(): void;
    get listPolicyInput(): OrganizationPolicyListPolicy | undefined;
    private _restorePolicy;
    get restorePolicy(): OrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: OrganizationPolicyRestorePolicy): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): OrganizationPolicyRestorePolicy | undefined;
    private _timeouts;
    get timeouts(): OrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: OrganizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): OrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
