import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The definition of the schema.
  This should contain a string representing the full definition of the schema
  that is a valid schema definition of the type specified in type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#definition PubsubSchema#definition}
    */
    readonly definition?: string;
    /**
    * The ID to use for the schema, which will become the final component of the schema's resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#name PubsubSchema#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#project PubsubSchema#project}
    */
    readonly project?: string;
    /**
    * The type of the schema definition Default value: "TYPE_UNSPECIFIED" Possible values: ["TYPE_UNSPECIFIED", "PROTOCOL_BUFFER", "AVRO"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#type PubsubSchema#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#timeouts PubsubSchema#timeouts}
    */
    readonly timeouts?: PubsubSchemaTimeouts;
}
export interface PubsubSchemaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#create PubsubSchema#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#delete PubsubSchema#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema#update PubsubSchema#update}
    */
    readonly update?: string;
}
export declare function pubsubSchemaTimeoutsToTerraform(struct?: PubsubSchemaTimeoutsOutputReference | PubsubSchemaTimeouts | cdktf.IResolvable): any;
export declare class PubsubSchemaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PubsubSchemaTimeouts | undefined;
    set internalValue(value: PubsubSchemaTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema google_pubsub_schema}
*/
export declare class PubsubSchema extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema google_pubsub_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PubsubSchemaConfig
    */
    constructor(scope: Construct, id: string, config: PubsubSchemaConfig);
    private _definition?;
    get definition(): string;
    set definition(value: string);
    resetDefinition(): void;
    get definitionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): PubsubSchemaTimeoutsOutputReference;
    putTimeouts(value: PubsubSchemaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PubsubSchemaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
