import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Only applicable to STANDARD_HA tier which protects the instance
  against zonal failures by provisioning it across two zones.
  If provided, it must be a different zone from the one provided in
  [locationId].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#alternative_location_id RedisInstance#alternative_location_id}
    */
    readonly alternativeLocationId?: string;
    /**
    * Optional. Indicates whether OSS Redis AUTH is enabled for the
  instance. If set to "true" AUTH is enabled on the instance.
  Default value is "false" meaning AUTH is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#auth_enabled RedisInstance#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The full name of the Google Compute Engine network to which the
  instance is connected. If left unspecified, the default network
  will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#authorized_network RedisInstance#authorized_network}
    */
    readonly authorizedNetwork?: string;
    /**
    * The connection mode of the Redis instance. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#connect_mode RedisInstance#connect_mode}
    */
    readonly connectMode?: string;
    /**
    * An arbitrary and optional user-provided name for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#display_name RedisInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#labels RedisInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The zone where the instance will be provisioned. If not provided,
  the service will choose a zone for the instance. For STANDARD_HA tier,
  instances will be created across two zones for protection against
  zonal failures. If [alternativeLocationId] is also provided, it must
  be different from [locationId].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#location_id RedisInstance#location_id}
    */
    readonly locationId?: string;
    /**
    * Redis memory size in GiB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#memory_size_gb RedisInstance#memory_size_gb}
    */
    readonly memorySizeGb: number;
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#name RedisInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#project RedisInstance#project}
    */
    readonly project?: string;
    /**
    * Redis configuration parameters, according to http://redis.io/topics/config.
  Please check Memorystore documentation for the list of supported parameters:
  https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_configs RedisInstance#redis_configs}
    */
    readonly redisConfigs?: {
        [key: string]: string;
    };
    /**
    * The version of Redis software. If not provided, latest supported
  version will be used. Please check the API documentation linked
  at the top for the latest valid values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_version RedisInstance#redis_version}
    */
    readonly redisVersion?: string;
    /**
    * The name of the Redis region of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#region RedisInstance#region}
    */
    readonly region?: string;
    /**
    * The CIDR range of internal addresses that are reserved for this
  instance. If not provided, the service will choose an unused /29
  block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
  unique and non-overlapping with existing subnets in an authorized
  network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#reserved_ip_range RedisInstance#reserved_ip_range}
    */
    readonly reservedIpRange?: string;
    /**
    * The service tier of the instance. Must be one of these values:
  
  - BASIC: standalone instance
  - STANDARD_HA: highly available primary/replica instances Default value: "BASIC" Possible values: ["BASIC", "STANDARD_HA"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#tier RedisInstance#tier}
    */
    readonly tier?: string;
    /**
    * The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
  
  - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentcation Default value: "DISABLED" Possible values: ["SERVER_AUTHENTICATION", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#transit_encryption_mode RedisInstance#transit_encryption_mode}
    */
    readonly transitEncryptionMode?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#timeouts RedisInstance#timeouts}
    */
    readonly timeouts?: RedisInstanceTimeouts;
}
export declare class RedisInstanceServerCaCerts extends cdktf.ComplexComputedList {
    get cert(): string;
    get createTime(): string;
    get expireTime(): string;
    get serialNumber(): string;
    get sha1Fingerprint(): string;
}
export interface RedisInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#create RedisInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#delete RedisInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#update RedisInstance#update}
    */
    readonly update?: string;
}
export declare function redisInstanceTimeoutsToTerraform(struct?: RedisInstanceTimeoutsOutputReference | RedisInstanceTimeouts | cdktf.IResolvable): any;
export declare class RedisInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RedisInstanceTimeouts | undefined;
    set internalValue(value: RedisInstanceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/redis_instance google_redis_instance}
*/
export declare class RedisInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/redis_instance google_redis_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RedisInstanceConfig
    */
    constructor(scope: Construct, id: string, config: RedisInstanceConfig);
    private _alternativeLocationId?;
    get alternativeLocationId(): string;
    set alternativeLocationId(value: string);
    resetAlternativeLocationId(): void;
    get alternativeLocationIdInput(): string | undefined;
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get authString(): string;
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    private _connectMode?;
    get connectMode(): string;
    set connectMode(value: string);
    resetConnectMode(): void;
    get connectModeInput(): string | undefined;
    get createTime(): string;
    get currentLocationId(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get host(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    resetLocationId(): void;
    get locationIdInput(): string | undefined;
    private _memorySizeGb?;
    get memorySizeGb(): number;
    set memorySizeGb(value: number);
    get memorySizeGbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get persistenceIamIdentity(): string;
    get port(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _redisConfigs?;
    get redisConfigs(): {
        [key: string]: string;
    };
    set redisConfigs(value: {
        [key: string]: string;
    });
    resetRedisConfigs(): void;
    get redisConfigsInput(): {
        [key: string]: string;
    } | undefined;
    private _redisVersion?;
    get redisVersion(): string;
    set redisVersion(value: string);
    resetRedisVersion(): void;
    get redisVersionInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    resetReservedIpRange(): void;
    get reservedIpRangeInput(): string | undefined;
    serverCaCerts(index: string): RedisInstanceServerCaCerts;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _transitEncryptionMode?;
    get transitEncryptionMode(): string;
    set transitEncryptionMode(value: string);
    resetTransitEncryptionMode(): void;
    get transitEncryptionModeInput(): string | undefined;
    private _timeouts;
    get timeouts(): RedisInstanceTimeoutsOutputReference;
    putTimeouts(value: RedisInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): RedisInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
