import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretManagerSecretVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The current state of the SecretVersion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#enabled SecretManagerSecretVersion#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Secret Manager secret resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#secret SecretManagerSecretVersion#secret}
    */
    readonly secret: string;
    /**
    * The secret data. Must be no larger than 64KiB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#secret_data SecretManagerSecretVersion#secret_data}
    */
    readonly secretData: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#timeouts SecretManagerSecretVersion#timeouts}
    */
    readonly timeouts?: SecretManagerSecretVersionTimeouts;
}
export interface SecretManagerSecretVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#create SecretManagerSecretVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#delete SecretManagerSecretVersion#delete}
    */
    readonly delete?: string;
}
export declare function secretManagerSecretVersionTimeoutsToTerraform(struct?: SecretManagerSecretVersionTimeoutsOutputReference | SecretManagerSecretVersionTimeouts | cdktf.IResolvable): any;
export declare class SecretManagerSecretVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SecretManagerSecretVersionTimeouts | undefined;
    set internalValue(value: SecretManagerSecretVersionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version google_secret_manager_secret_version}
*/
export declare class SecretManagerSecretVersion extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version google_secret_manager_secret_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretManagerSecretVersionConfig
    */
    constructor(scope: Construct, id: string, config: SecretManagerSecretVersionConfig);
    get createTime(): string;
    get destroyTime(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _secretData?;
    get secretData(): string;
    set secretData(value: string);
    get secretDataInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecretManagerSecretVersionTimeoutsOutputReference;
    putTimeouts(value: SecretManagerSecretVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SecretManagerSecretVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
