import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceAccountIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member#member ServiceAccountIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member#role ServiceAccountIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member#service_account_id ServiceAccountIamMember#service_account_id}
    */
    readonly serviceAccountId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member#condition ServiceAccountIamMember#condition}
    */
    readonly condition?: ServiceAccountIamMemberCondition;
}
export interface ServiceAccountIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member#description ServiceAccountIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member#expression ServiceAccountIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member#title ServiceAccountIamMember#title}
    */
    readonly title: string;
}
export declare function serviceAccountIamMemberConditionToTerraform(struct?: ServiceAccountIamMemberConditionOutputReference | ServiceAccountIamMemberCondition): any;
export declare class ServiceAccountIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceAccountIamMemberCondition | undefined;
    set internalValue(value: ServiceAccountIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member google_service_account_iam_member}
*/
export declare class ServiceAccountIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_member google_service_account_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceAccountIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: ServiceAccountIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceAccountId?;
    get serviceAccountId(): string;
    set serviceAccountId(value: string);
    get serviceAccountIdInput(): string | undefined;
    private _condition;
    get condition(): ServiceAccountIamMemberConditionOutputReference;
    putCondition(value: ServiceAccountIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): ServiceAccountIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
