import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpannerDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional list of DDL statements to run inside the newly created
  database. Statements can create tables, indexes, etc. These statements
  execute atomically with the creation of the database: if there is an
  error in any statement, the database is not created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#ddl SpannerDatabase#ddl}
    */
    readonly ddl?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#deletion_protection SpannerDatabase#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * The instance to create the database on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#instance SpannerDatabase#instance}
    */
    readonly instance: string;
    /**
    * A unique identifier for the database, which cannot be changed after
  the instance is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#name SpannerDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#project SpannerDatabase#project}
    */
    readonly project?: string;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#encryption_config SpannerDatabase#encryption_config}
    */
    readonly encryptionConfig?: SpannerDatabaseEncryptionConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#timeouts SpannerDatabase#timeouts}
    */
    readonly timeouts?: SpannerDatabaseTimeouts;
}
export interface SpannerDatabaseEncryptionConfig {
    /**
    * Fully qualified name of the KMS key to use to encrypt this database. This key must exist
  in the same location as the Spanner Database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#kms_key_name SpannerDatabase#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function spannerDatabaseEncryptionConfigToTerraform(struct?: SpannerDatabaseEncryptionConfigOutputReference | SpannerDatabaseEncryptionConfig): any;
export declare class SpannerDatabaseEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpannerDatabaseEncryptionConfig | undefined;
    set internalValue(value: SpannerDatabaseEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface SpannerDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#create SpannerDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#delete SpannerDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#update SpannerDatabase#update}
    */
    readonly update?: string;
}
export declare function spannerDatabaseTimeoutsToTerraform(struct?: SpannerDatabaseTimeoutsOutputReference | SpannerDatabaseTimeouts | cdktf.IResolvable): any;
export declare class SpannerDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpannerDatabaseTimeouts | undefined;
    set internalValue(value: SpannerDatabaseTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/spanner_database google_spanner_database}
*/
export declare class SpannerDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/spanner_database google_spanner_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpannerDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: SpannerDatabaseConfig);
    private _ddl?;
    get ddl(): string[];
    set ddl(value: string[]);
    resetDdl(): void;
    get ddlInput(): string[] | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _encryptionConfig;
    get encryptionConfig(): SpannerDatabaseEncryptionConfigOutputReference;
    putEncryptionConfig(value: SpannerDatabaseEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): SpannerDatabaseEncryptionConfig | undefined;
    private _timeouts;
    get timeouts(): SpannerDatabaseTimeoutsOutputReference;
    putTimeouts(value: SpannerDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SpannerDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
