import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDefaultObjectAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl#bucket StorageDefaultObjectAcl#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl#role_entity StorageDefaultObjectAcl#role_entity}
    */
    readonly roleEntity?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl google_storage_default_object_acl}
*/
export declare class StorageDefaultObjectAcl extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl google_storage_default_object_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDefaultObjectAclConfig
    */
    constructor(scope: Construct, id: string, config: StorageDefaultObjectAclConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get id(): string;
    private _roleEntity?;
    get roleEntity(): string[];
    set roleEntity(value: string[]);
    resetRoleEntity(): void;
    get roleEntityInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
