import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TpuNodeConfig extends cdktf.TerraformMetaArguments {
    /**
    * The type of hardware accelerators associated with this node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#accelerator_type TpuNode#accelerator_type}
    */
    readonly acceleratorType: string;
    /**
    * The CIDR block that the TPU node will use when selecting an IP
  address. This CIDR block must be a /29 block; the Compute Engine
  networks API forbids a smaller block, and using a larger block would
  be wasteful (a node can only consume one IP address).
  
  Errors will occur if the CIDR block has already been used for a
  currently existing TPU node, the CIDR block conflicts with any
  subnetworks in the user's provided network, or the provided network
  is peered with another network that is using that CIDR block.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#cidr_block TpuNode#cidr_block}
    */
    readonly cidrBlock?: string;
    /**
    * The user-supplied description of the TPU. Maximum of 512 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#description TpuNode#description}
    */
    readonly description?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#labels TpuNode#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The immutable name of the TPU.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#name TpuNode#name}
    */
    readonly name: string;
    /**
    * The name of a network to peer the TPU node to. It must be a
  preexisting Compute Engine network inside of the project on which
  this API has been activated. If none is provided, "default" will be
  used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#network TpuNode#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#project TpuNode#project}
    */
    readonly project?: string;
    /**
    * The version of Tensorflow running in the Node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#tensorflow_version TpuNode#tensorflow_version}
    */
    readonly tensorflowVersion: string;
    /**
    * Whether the VPC peering for the node is set up through Service Networking API.
  The VPC Peering should be set up before provisioning the node. If this field is set,
  cidr_block field should not be specified. If the network that you want to peer the
  TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#use_service_networking TpuNode#use_service_networking}
    */
    readonly useServiceNetworking?: boolean | cdktf.IResolvable;
    /**
    * The GCP location for the TPU. If it is not provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#zone TpuNode#zone}
    */
    readonly zone?: string;
    /**
    * scheduling_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#scheduling_config TpuNode#scheduling_config}
    */
    readonly schedulingConfig?: TpuNodeSchedulingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#timeouts TpuNode#timeouts}
    */
    readonly timeouts?: TpuNodeTimeouts;
}
export declare class TpuNodeNetworkEndpoints extends cdktf.ComplexComputedList {
    get ipAddress(): string;
    get port(): number;
}
export interface TpuNodeSchedulingConfig {
    /**
    * Defines whether the TPU instance is preemptible.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#preemptible TpuNode#preemptible}
    */
    readonly preemptible: boolean | cdktf.IResolvable;
}
export declare function tpuNodeSchedulingConfigToTerraform(struct?: TpuNodeSchedulingConfigOutputReference | TpuNodeSchedulingConfig): any;
export declare class TpuNodeSchedulingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): TpuNodeSchedulingConfig | undefined;
    set internalValue(value: TpuNodeSchedulingConfig | undefined);
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
}
export interface TpuNodeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#create TpuNode#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#delete TpuNode#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node#update TpuNode#update}
    */
    readonly update?: string;
}
export declare function tpuNodeTimeoutsToTerraform(struct?: TpuNodeTimeoutsOutputReference | TpuNodeTimeouts | cdktf.IResolvable): any;
export declare class TpuNodeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): TpuNodeTimeouts | undefined;
    set internalValue(value: TpuNodeTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/tpu_node google_tpu_node}
*/
export declare class TpuNode extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/tpu_node google_tpu_node} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TpuNodeConfig
    */
    constructor(scope: Construct, id: string, config: TpuNodeConfig);
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    get acceleratorTypeInput(): string | undefined;
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    resetCidrBlock(): void;
    get cidrBlockInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    networkEndpoints(index: string): TpuNodeNetworkEndpoints;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceAccount(): string;
    private _tensorflowVersion?;
    get tensorflowVersion(): string;
    set tensorflowVersion(value: string);
    get tensorflowVersionInput(): string | undefined;
    private _useServiceNetworking?;
    get useServiceNetworking(): boolean | cdktf.IResolvable;
    set useServiceNetworking(value: boolean | cdktf.IResolvable);
    resetUseServiceNetworking(): void;
    get useServiceNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _schedulingConfig;
    get schedulingConfig(): TpuNodeSchedulingConfigOutputReference;
    putSchedulingConfig(value: TpuNodeSchedulingConfig): void;
    resetSchedulingConfig(): void;
    get schedulingConfigInput(): TpuNodeSchedulingConfig | undefined;
    private _timeouts;
    get timeouts(): TpuNodeTimeoutsOutputReference;
    putTimeouts(value: TpuNodeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): TpuNodeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
