import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcAccessConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * The range of internal addresses that follows RFC 4632 notation. Example: '10.132.0.0/28'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#ip_cidr_range VpcAccessConnector#ip_cidr_range}
    */
    readonly ipCidrRange?: string;
    /**
    * Maximum throughput of the connector in Mbps, must be greater than 'min_throughput'. Default is 300.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#max_throughput VpcAccessConnector#max_throughput}
    */
    readonly maxThroughput?: number;
    /**
    * Minimum throughput of the connector in Mbps. Default and min is 200.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#min_throughput VpcAccessConnector#min_throughput}
    */
    readonly minThroughput?: number;
    /**
    * The name of the resource (Max 25 characters).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#name VpcAccessConnector#name}
    */
    readonly name: string;
    /**
    * Name of the VPC network. Required if 'ip_cidr_range' is set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#network VpcAccessConnector#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#project VpcAccessConnector#project}
    */
    readonly project?: string;
    /**
    * Region where the VPC Access connector resides. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#region VpcAccessConnector#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#timeouts VpcAccessConnector#timeouts}
    */
    readonly timeouts?: VpcAccessConnectorTimeouts;
}
export interface VpcAccessConnectorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#create VpcAccessConnector#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#delete VpcAccessConnector#delete}
    */
    readonly delete?: string;
}
export declare function vpcAccessConnectorTimeoutsToTerraform(struct?: VpcAccessConnectorTimeoutsOutputReference | VpcAccessConnectorTimeouts | cdktf.IResolvable): any;
export declare class VpcAccessConnectorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpcAccessConnectorTimeouts | undefined;
    set internalValue(value: VpcAccessConnectorTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector google_vpc_access_connector}
*/
export declare class VpcAccessConnector extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector google_vpc_access_connector} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcAccessConnectorConfig
    */
    constructor(scope: Construct, id: string, config: VpcAccessConnectorConfig);
    get id(): string;
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    resetIpCidrRange(): void;
    get ipCidrRangeInput(): string | undefined;
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
    private _minThroughput?;
    get minThroughput(): number;
    set minThroughput(value: number);
    resetMinThroughput(): void;
    get minThroughputInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    get state(): string;
    private _timeouts;
    get timeouts(): VpcAccessConnectorTimeoutsOutputReference;
    putTimeouts(value: VpcAccessConnectorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpcAccessConnectorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
