import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryTableConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies column names to use for data clustering.
     *
     * Up to four top-level columns are allowed, and should be specified in descending priority order.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#clustering BigqueryTable#clustering}
     *
     * @stability stable
     */
    readonly clustering?: string[];
    /**
     * The dataset ID to create the table in. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#dataset_id BigqueryTable#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * Whether or not to allow Terraform to destroy the instance.
     *
     * Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#deletion_protection BigqueryTable#deletion_protection}
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The field description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#description BigqueryTable#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The time when this table expires, in milliseconds since the epoch.
     *
     * If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#expiration_time BigqueryTable#expiration_time}
     *
     * @stability stable
     */
    readonly expirationTime?: number;
    /**
     * A descriptive name for the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#friendly_name BigqueryTable#friendly_name}
     *
     * @stability stable
     */
    readonly friendlyName?: string;
    /**
     * A mapping of labels to assign to the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#labels BigqueryTable#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The ID of the project in which the resource belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#project BigqueryTable#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A JSON schema for the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#schema BigqueryTable#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * A unique ID for the resource. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#table_id BigqueryTable#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
    /**
     * encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#encryption_configuration BigqueryTable#encryption_configuration}
     *
     * @stability stable
     */
    readonly encryptionConfiguration?: BigqueryTableEncryptionConfiguration;
    /**
     * external_data_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#external_data_configuration BigqueryTable#external_data_configuration}
     *
     * @stability stable
     */
    readonly externalDataConfiguration?: BigqueryTableExternalDataConfiguration;
    /**
     * materialized_view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#materialized_view BigqueryTable#materialized_view}
     *
     * @stability stable
     */
    readonly materializedView?: BigqueryTableMaterializedView;
    /**
     * range_partitioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#range_partitioning BigqueryTable#range_partitioning}
     *
     * @stability stable
     */
    readonly rangePartitioning?: BigqueryTableRangePartitioning;
    /**
     * time_partitioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#time_partitioning BigqueryTable#time_partitioning}
     *
     * @stability stable
     */
    readonly timePartitioning?: BigqueryTableTimePartitioning;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#view BigqueryTable#view}
     *
     * @stability stable
     */
    readonly view?: BigqueryTableView;
}
/**
 * @stability stable
 */
export interface BigqueryTableEncryptionConfiguration {
    /**
     * The self link or full name of a key which should be used to encrypt this table.
     *
     * Note that the default bigquery service account will need to have encrypt/decrypt permissions on this key - you may want to see the google_bigquery_default_service_account datasource and the google_kms_crypto_key_iam_binding resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#kms_key_name BigqueryTable#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
export declare function bigqueryTableEncryptionConfigurationToTerraform(struct?: BigqueryTableEncryptionConfigurationOutputReference | BigqueryTableEncryptionConfiguration): any;
/**
 * @stability stable
 */
export declare class BigqueryTableEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableEncryptionConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableExternalDataConfigurationCsvOptions {
    /**
     * Indicates if BigQuery should accept rows that are missing trailing optional columns.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#allow_jagged_rows BigqueryTable#allow_jagged_rows}
     *
     * @stability stable
     */
    readonly allowJaggedRows?: boolean | cdktf.IResolvable;
    /**
     * Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
     *
     * The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#allow_quoted_newlines BigqueryTable#allow_quoted_newlines}
     *
     * @stability stable
     */
    readonly allowQuotedNewlines?: boolean | cdktf.IResolvable;
    /**
     * The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#encoding BigqueryTable#encoding}
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * The separator for fields in a CSV file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#field_delimiter BigqueryTable#field_delimiter}
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * The value that is used to quote data sections in a CSV file.
     *
     * If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allow_quoted_newlines property to true. The API-side default is ", specified in Terraform escaped as \". Due to limitations with Terraform default values, this value is required to be explicitly set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#quote BigqueryTable#quote}
     *
     * @stability stable
     */
    readonly quote: string;
    /**
     * The number of rows at the top of a CSV file that BigQuery will skip when reading the data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#skip_leading_rows BigqueryTable#skip_leading_rows}
     *
     * @stability stable
     */
    readonly skipLeadingRows?: number;
}
export declare function bigqueryTableExternalDataConfigurationCsvOptionsToTerraform(struct?: BigqueryTableExternalDataConfigurationCsvOptionsOutputReference | BigqueryTableExternalDataConfigurationCsvOptions): any;
/**
 * @stability stable
 */
export declare class BigqueryTableExternalDataConfigurationCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableExternalDataConfigurationCsvOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableExternalDataConfigurationCsvOptions | undefined);
    private _allowJaggedRows?;
    /**
     * @stability stable
     */
    get allowJaggedRows(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowJaggedRows(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowJaggedRows(): void;
    /**
     * @stability stable
     */
    get allowJaggedRowsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowQuotedNewlines?;
    /**
     * @stability stable
     */
    get allowQuotedNewlines(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowQuotedNewlines(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowQuotedNewlines(): void;
    /**
     * @stability stable
     */
    get allowQuotedNewlinesInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _quote?;
    /**
     * @stability stable
     */
    get quote(): string;
    /**
     * @stability stable
     */
    set quote(value: string);
    /**
     * @stability stable
     */
    get quoteInput(): string | undefined;
    private _skipLeadingRows?;
    /**
     * @stability stable
     */
    get skipLeadingRows(): number;
    /**
     * @stability stable
     */
    set skipLeadingRows(value: number);
    /**
     * @stability stable
     */
    resetSkipLeadingRows(): void;
    /**
     * @stability stable
     */
    get skipLeadingRowsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableExternalDataConfigurationGoogleSheetsOptions {
    /**
     * Range of a sheet to query from.
     *
     * Only used when non-empty. At least one of range or skip_leading_rows must be set. Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id" For example: "sheet1!A1:B20"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#range BigqueryTable#range}
     *
     * @stability stable
     */
    readonly range?: string;
    /**
     * The number of rows at the top of the sheet that BigQuery will skip when reading the data.
     *
     * At least one of range or skip_leading_rows must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#skip_leading_rows BigqueryTable#skip_leading_rows}
     *
     * @stability stable
     */
    readonly skipLeadingRows?: number;
}
export declare function bigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform(struct?: BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference | BigqueryTableExternalDataConfigurationGoogleSheetsOptions): any;
/**
 * @stability stable
 */
export declare class BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined);
    private _range?;
    /**
     * @stability stable
     */
    get range(): string;
    /**
     * @stability stable
     */
    set range(value: string);
    /**
     * @stability stable
     */
    resetRange(): void;
    /**
     * @stability stable
     */
    get rangeInput(): string | undefined;
    private _skipLeadingRows?;
    /**
     * @stability stable
     */
    get skipLeadingRows(): number;
    /**
     * @stability stable
     */
    set skipLeadingRows(value: number);
    /**
     * @stability stable
     */
    resetSkipLeadingRows(): void;
    /**
     * @stability stable
     */
    get skipLeadingRowsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableExternalDataConfigurationHivePartitioningOptions {
    /**
     * When set, what mode of hive partitioning to use when reading data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#mode BigqueryTable#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#require_partition_filter BigqueryTable#require_partition_filter}
     *
     * @stability stable
     */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
     * When hive partition detection is requested, a common for all source uris must be required.
     *
     * The prefix must end immediately before the partition key encoding begins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#source_uri_prefix BigqueryTable#source_uri_prefix}
     *
     * @stability stable
     */
    readonly sourceUriPrefix?: string;
}
export declare function bigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform(struct?: BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference | BigqueryTableExternalDataConfigurationHivePartitioningOptions): any;
/**
 * @stability stable
 */
export declare class BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _requirePartitionFilter?;
    /**
     * @stability stable
     */
    get requirePartitionFilter(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requirePartitionFilter(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequirePartitionFilter(): void;
    /**
     * @stability stable
     */
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceUriPrefix?;
    /**
     * @stability stable
     */
    get sourceUriPrefix(): string;
    /**
     * @stability stable
     */
    set sourceUriPrefix(value: string);
    /**
     * @stability stable
     */
    resetSourceUriPrefix(): void;
    /**
     * @stability stable
     */
    get sourceUriPrefixInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableExternalDataConfiguration {
    /**
     * Let BigQuery try to autodetect the schema and format of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#autodetect BigqueryTable#autodetect}
     *
     * @stability stable
     */
    readonly autodetect: boolean | cdktf.IResolvable;
    /**
     * The compression type of the data source. Valid values are "NONE" or "GZIP".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#compression BigqueryTable#compression}
     *
     * @stability stable
     */
    readonly compression?: string;
    /**
     * Indicates if BigQuery should allow extra values that are not represented in the table schema.
     *
     * If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#ignore_unknown_values BigqueryTable#ignore_unknown_values}
     *
     * @stability stable
     */
    readonly ignoreUnknownValues?: boolean | cdktf.IResolvable;
    /**
     * The maximum number of bad records that BigQuery can ignore when reading data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#max_bad_records BigqueryTable#max_bad_records}
     *
     * @stability stable
     */
    readonly maxBadRecords?: number;
    /**
     * A JSON schema for the external table.
     *
     * Schema is required for CSV and JSON formats and is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats when using external tables.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#schema BigqueryTable#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * The data format.
     *
     * Supported values are: "CSV", "GOOGLE_SHEETS", "NEWLINE_DELIMITED_JSON", "AVRO", "PARQUET", "ORC" and "DATASTORE_BACKUP". To use "GOOGLE_SHEETS" the scopes must include "googleapis.com/auth/drive.readonly".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#source_format BigqueryTable#source_format}
     *
     * @stability stable
     */
    readonly sourceFormat: string;
    /**
     * A list of the fully-qualified URIs that point to your data in Google Cloud.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#source_uris BigqueryTable#source_uris}
     *
     * @stability stable
     */
    readonly sourceUris: string[];
    /**
     * csv_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#csv_options BigqueryTable#csv_options}
     *
     * @stability stable
     */
    readonly csvOptions?: BigqueryTableExternalDataConfigurationCsvOptions;
    /**
     * google_sheets_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#google_sheets_options BigqueryTable#google_sheets_options}
     *
     * @stability stable
     */
    readonly googleSheetsOptions?: BigqueryTableExternalDataConfigurationGoogleSheetsOptions;
    /**
     * hive_partitioning_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#hive_partitioning_options BigqueryTable#hive_partitioning_options}
     *
     * @stability stable
     */
    readonly hivePartitioningOptions?: BigqueryTableExternalDataConfigurationHivePartitioningOptions;
}
export declare function bigqueryTableExternalDataConfigurationToTerraform(struct?: BigqueryTableExternalDataConfigurationOutputReference | BigqueryTableExternalDataConfiguration): any;
/**
 * @stability stable
 */
export declare class BigqueryTableExternalDataConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableExternalDataConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableExternalDataConfiguration | undefined);
    private _autodetect?;
    /**
     * @stability stable
     */
    get autodetect(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autodetect(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get autodetectInput(): boolean | cdktf.IResolvable | undefined;
    private _compression?;
    /**
     * @stability stable
     */
    get compression(): string;
    /**
     * @stability stable
     */
    set compression(value: string);
    /**
     * @stability stable
     */
    resetCompression(): void;
    /**
     * @stability stable
     */
    get compressionInput(): string | undefined;
    private _ignoreUnknownValues?;
    /**
     * @stability stable
     */
    get ignoreUnknownValues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreUnknownValues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreUnknownValues(): void;
    /**
     * @stability stable
     */
    get ignoreUnknownValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBadRecords?;
    /**
     * @stability stable
     */
    get maxBadRecords(): number;
    /**
     * @stability stable
     */
    set maxBadRecords(value: number);
    /**
     * @stability stable
     */
    resetMaxBadRecords(): void;
    /**
     * @stability stable
     */
    get maxBadRecordsInput(): number | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    resetSchema(): void;
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _sourceFormat?;
    /**
     * @stability stable
     */
    get sourceFormat(): string;
    /**
     * @stability stable
     */
    set sourceFormat(value: string);
    /**
     * @stability stable
     */
    get sourceFormatInput(): string | undefined;
    private _sourceUris?;
    /**
     * @stability stable
     */
    get sourceUris(): string[];
    /**
     * @stability stable
     */
    set sourceUris(value: string[]);
    /**
     * @stability stable
     */
    get sourceUrisInput(): string[] | undefined;
    private _csvOptions;
    /**
     * @stability stable
     */
    get csvOptions(): BigqueryTableExternalDataConfigurationCsvOptionsOutputReference;
    /**
     * @stability stable
     */
    putCsvOptions(value: BigqueryTableExternalDataConfigurationCsvOptions): void;
    /**
     * @stability stable
     */
    resetCsvOptions(): void;
    /**
     * @stability stable
     */
    get csvOptionsInput(): BigqueryTableExternalDataConfigurationCsvOptions | undefined;
    private _googleSheetsOptions;
    /**
     * @stability stable
     */
    get googleSheetsOptions(): BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference;
    /**
     * @stability stable
     */
    putGoogleSheetsOptions(value: BigqueryTableExternalDataConfigurationGoogleSheetsOptions): void;
    /**
     * @stability stable
     */
    resetGoogleSheetsOptions(): void;
    /**
     * @stability stable
     */
    get googleSheetsOptionsInput(): BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined;
    private _hivePartitioningOptions;
    /**
     * @stability stable
     */
    get hivePartitioningOptions(): BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference;
    /**
     * @stability stable
     */
    putHivePartitioningOptions(value: BigqueryTableExternalDataConfigurationHivePartitioningOptions): void;
    /**
     * @stability stable
     */
    resetHivePartitioningOptions(): void;
    /**
     * @stability stable
     */
    get hivePartitioningOptionsInput(): BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableMaterializedView {
    /**
     * Specifies if BigQuery should automatically refresh materialized view when the base table is updated. The default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#enable_refresh BigqueryTable#enable_refresh}
     *
     * @stability stable
     */
    readonly enableRefresh?: boolean | cdktf.IResolvable;
    /**
     * A query whose result is persisted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#query BigqueryTable#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * Specifies maximum frequency at which this materialized view will be refreshed. The default is 1800000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#refresh_interval_ms BigqueryTable#refresh_interval_ms}
     *
     * @stability stable
     */
    readonly refreshIntervalMs?: number;
}
export declare function bigqueryTableMaterializedViewToTerraform(struct?: BigqueryTableMaterializedViewOutputReference | BigqueryTableMaterializedView): any;
/**
 * @stability stable
 */
export declare class BigqueryTableMaterializedViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableMaterializedView | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableMaterializedView | undefined);
    private _enableRefresh?;
    /**
     * @stability stable
     */
    get enableRefresh(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableRefresh(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableRefresh(): void;
    /**
     * @stability stable
     */
    get enableRefreshInput(): boolean | cdktf.IResolvable | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _refreshIntervalMs?;
    /**
     * @stability stable
     */
    get refreshIntervalMs(): number;
    /**
     * @stability stable
     */
    set refreshIntervalMs(value: number);
    /**
     * @stability stable
     */
    resetRefreshIntervalMs(): void;
    /**
     * @stability stable
     */
    get refreshIntervalMsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableRangePartitioningRange {
    /**
     * End of the range partitioning, exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#end BigqueryTable#end}
     *
     * @stability stable
     */
    readonly end: number;
    /**
     * The width of each range within the partition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#interval BigqueryTable#interval}
     *
     * @stability stable
     */
    readonly interval: number;
    /**
     * Start of the range partitioning, inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#start BigqueryTable#start}
     *
     * @stability stable
     */
    readonly start: number;
}
export declare function bigqueryTableRangePartitioningRangeToTerraform(struct?: BigqueryTableRangePartitioningRangeOutputReference | BigqueryTableRangePartitioningRange): any;
/**
 * @stability stable
 */
export declare class BigqueryTableRangePartitioningRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableRangePartitioningRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableRangePartitioningRange | undefined);
    private _end?;
    /**
     * @stability stable
     */
    get end(): number;
    /**
     * @stability stable
     */
    set end(value: number);
    /**
     * @stability stable
     */
    get endInput(): number | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): number;
    /**
     * @stability stable
     */
    set start(value: number);
    /**
     * @stability stable
     */
    get startInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableRangePartitioning {
    /**
     * The field used to determine how to create a range-based partition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#field BigqueryTable#field}
     *
     * @stability stable
     */
    readonly field: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#range BigqueryTable#range}
     *
     * @stability stable
     */
    readonly range: BigqueryTableRangePartitioningRange;
}
export declare function bigqueryTableRangePartitioningToTerraform(struct?: BigqueryTableRangePartitioningOutputReference | BigqueryTableRangePartitioning): any;
/**
 * @stability stable
 */
export declare class BigqueryTableRangePartitioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableRangePartitioning | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableRangePartitioning | undefined);
    private _field?;
    /**
     * @stability stable
     */
    get field(): string;
    /**
     * @stability stable
     */
    set field(value: string);
    /**
     * @stability stable
     */
    get fieldInput(): string | undefined;
    private _range;
    /**
     * @stability stable
     */
    get range(): BigqueryTableRangePartitioningRangeOutputReference;
    /**
     * @stability stable
     */
    putRange(value: BigqueryTableRangePartitioningRange): void;
    /**
     * @stability stable
     */
    get rangeInput(): BigqueryTableRangePartitioningRange | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableTimePartitioning {
    /**
     * Number of milliseconds for which to keep the storage for a partition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#expiration_ms BigqueryTable#expiration_ms}
     *
     * @stability stable
     */
    readonly expirationMs?: number;
    /**
     * The field used to determine how to create a time-based partition.
     *
     * If time-based partitioning is enabled without this value, the table is partitioned based on the load time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#field BigqueryTable#field}
     *
     * @stability stable
     */
    readonly field?: string;
    /**
     * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#require_partition_filter BigqueryTable#require_partition_filter}
     *
     * @stability stable
     */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
     * The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#type BigqueryTable#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function bigqueryTableTimePartitioningToTerraform(struct?: BigqueryTableTimePartitioningOutputReference | BigqueryTableTimePartitioning): any;
/**
 * @stability stable
 */
export declare class BigqueryTableTimePartitioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableTimePartitioning | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableTimePartitioning | undefined);
    private _expirationMs?;
    /**
     * @stability stable
     */
    get expirationMs(): number;
    /**
     * @stability stable
     */
    set expirationMs(value: number);
    /**
     * @stability stable
     */
    resetExpirationMs(): void;
    /**
     * @stability stable
     */
    get expirationMsInput(): number | undefined;
    private _field?;
    /**
     * @stability stable
     */
    get field(): string;
    /**
     * @stability stable
     */
    set field(value: string);
    /**
     * @stability stable
     */
    resetField(): void;
    /**
     * @stability stable
     */
    get fieldInput(): string | undefined;
    private _requirePartitionFilter?;
    /**
     * @stability stable
     */
    get requirePartitionFilter(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requirePartitionFilter(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequirePartitionFilter(): void;
    /**
     * @stability stable
     */
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryTableView {
    /**
     * A query that BigQuery executes when the view is referenced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#query BigqueryTable#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * Specifies whether to use BigQuery's legacy SQL for this view.
     *
     * The default value is true. If set to false, the view will use BigQuery's standard SQL
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#use_legacy_sql BigqueryTable#use_legacy_sql}
     *
     * @stability stable
     */
    readonly useLegacySql?: boolean | cdktf.IResolvable;
}
export declare function bigqueryTableViewToTerraform(struct?: BigqueryTableViewOutputReference | BigqueryTableView): any;
/**
 * @stability stable
 */
export declare class BigqueryTableViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryTableView | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryTableView | undefined);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _useLegacySql?;
    /**
     * @stability stable
     */
    get useLegacySql(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useLegacySql(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseLegacySql(): void;
    /**
     * @stability stable
     */
    get useLegacySqlInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html google_bigquery_table}.
 *
 * @stability stable
 */
export declare class BigqueryTable extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html google_bigquery_table} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryTableConfig);
    private _clustering?;
    /**
     * @stability stable
     */
    get clustering(): string[];
    /**
     * @stability stable
     */
    set clustering(value: string[]);
    /**
     * @stability stable
     */
    resetClustering(): void;
    /**
     * @stability stable
     */
    get clusteringInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get creationTime(): number;
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    private _expirationTime?;
    /**
     * @stability stable
     */
    get expirationTime(): number;
    /**
     * @stability stable
     */
    set expirationTime(value: number);
    /**
     * @stability stable
     */
    resetExpirationTime(): void;
    /**
     * @stability stable
     */
    get expirationTimeInput(): number | undefined;
    private _friendlyName?;
    /**
     * @stability stable
     */
    get friendlyName(): string;
    /**
     * @stability stable
     */
    set friendlyName(value: string);
    /**
     * @stability stable
     */
    resetFriendlyName(): void;
    /**
     * @stability stable
     */
    get friendlyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get lastModifiedTime(): number;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get numBytes(): number;
    /**
     * @stability stable
     */
    get numLongTermBytes(): number;
    /**
     * @stability stable
     */
    get numRows(): number;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    resetSchema(): void;
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _encryptionConfiguration;
    /**
     * @stability stable
     */
    get encryptionConfiguration(): BigqueryTableEncryptionConfigurationOutputReference;
    /**
     * @stability stable
     */
    putEncryptionConfiguration(value: BigqueryTableEncryptionConfiguration): void;
    /**
     * @stability stable
     */
    resetEncryptionConfiguration(): void;
    /**
     * @stability stable
     */
    get encryptionConfigurationInput(): BigqueryTableEncryptionConfiguration | undefined;
    private _externalDataConfiguration;
    /**
     * @stability stable
     */
    get externalDataConfiguration(): BigqueryTableExternalDataConfigurationOutputReference;
    /**
     * @stability stable
     */
    putExternalDataConfiguration(value: BigqueryTableExternalDataConfiguration): void;
    /**
     * @stability stable
     */
    resetExternalDataConfiguration(): void;
    /**
     * @stability stable
     */
    get externalDataConfigurationInput(): BigqueryTableExternalDataConfiguration | undefined;
    private _materializedView;
    /**
     * @stability stable
     */
    get materializedView(): BigqueryTableMaterializedViewOutputReference;
    /**
     * @stability stable
     */
    putMaterializedView(value: BigqueryTableMaterializedView): void;
    /**
     * @stability stable
     */
    resetMaterializedView(): void;
    /**
     * @stability stable
     */
    get materializedViewInput(): BigqueryTableMaterializedView | undefined;
    private _rangePartitioning;
    /**
     * @stability stable
     */
    get rangePartitioning(): BigqueryTableRangePartitioningOutputReference;
    /**
     * @stability stable
     */
    putRangePartitioning(value: BigqueryTableRangePartitioning): void;
    /**
     * @stability stable
     */
    resetRangePartitioning(): void;
    /**
     * @stability stable
     */
    get rangePartitioningInput(): BigqueryTableRangePartitioning | undefined;
    private _timePartitioning;
    /**
     * @stability stable
     */
    get timePartitioning(): BigqueryTableTimePartitioningOutputReference;
    /**
     * @stability stable
     */
    putTimePartitioning(value: BigqueryTableTimePartitioning): void;
    /**
     * @stability stable
     */
    resetTimePartitioning(): void;
    /**
     * @stability stable
     */
    get timePartitioningInput(): BigqueryTableTimePartitioning | undefined;
    private _view;
    /**
     * @stability stable
     */
    get view(): BigqueryTableViewOutputReference;
    /**
     * @stability stable
     */
    putView(value: BigqueryTableView): void;
    /**
     * @stability stable
     */
    resetView(): void;
    /**
     * @stability stable
     */
    get viewInput(): BigqueryTableView | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
