import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleServiceAccountIdTokenConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#delegates DataGoogleServiceAccountIdToken#delegates}.
     *
     * @stability stable
     */
    readonly delegates?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#include_email DataGoogleServiceAccountIdToken#include_email}.
     *
     * @stability stable
     */
    readonly includeEmail?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#target_audience DataGoogleServiceAccountIdToken#target_audience}.
     *
     * @stability stable
     */
    readonly targetAudience: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#target_service_account DataGoogleServiceAccountIdToken#target_service_account}.
     *
     * @stability stable
     */
    readonly targetServiceAccount?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html google_service_account_id_token}.
 *
 * @stability stable
 */
export declare class DataGoogleServiceAccountIdToken extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html google_service_account_id_token} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountIdTokenConfig);
    private _delegates?;
    /**
     * @stability stable
     */
    get delegates(): string[];
    /**
     * @stability stable
     */
    set delegates(value: string[]);
    /**
     * @stability stable
     */
    resetDelegates(): void;
    /**
     * @stability stable
     */
    get delegatesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get idToken(): string;
    private _includeEmail?;
    /**
     * @stability stable
     */
    get includeEmail(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeEmail(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeEmail(): void;
    /**
     * @stability stable
     */
    get includeEmailInput(): boolean | cdktf.IResolvable | undefined;
    private _targetAudience?;
    /**
     * @stability stable
     */
    get targetAudience(): string;
    /**
     * @stability stable
     */
    set targetAudience(value: string);
    /**
     * @stability stable
     */
    get targetAudienceInput(): string | undefined;
    private _targetServiceAccount?;
    /**
     * @stability stable
     */
    get targetServiceAccount(): string;
    /**
     * @stability stable
     */
    set targetServiceAccount(value: string);
    /**
     * @stability stable
     */
    resetTargetServiceAccount(): void;
    /**
     * @stability stable
     */
    get targetServiceAccountInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
