"use strict";
const util_1 = require("../lib/util");
module.exports = {
    mergeEventPattern: {
        'happy case'(test) {
            test.deepEqual(util_1.mergeEventPattern({
                bar: [1, 2],
                hey: ['happy'],
                hello: {
                    world: ['hi', 'dude'],
                    case: [1],
                },
            }, {
                hey: ['day', 'today'],
                hello: {
                    world: ['you'],
                },
            }), {
                bar: [1, 2],
                hey: ['happy', 'day', 'today'],
                hello: {
                    world: ['hi', 'dude', 'you'],
                    case: [1],
                },
            });
            test.done();
        },
        'merge into an empty destination'(test) {
            test.deepEqual(util_1.mergeEventPattern(undefined, { foo: ['123'] }), { foo: [123] });
            test.deepEqual(util_1.mergeEventPattern(undefined, { foo: { bar: ['123'] } }), { foo: { bar: [123] } });
            test.deepEqual(util_1.mergeEventPattern({}, { foo: { bar: ['123'] } }), { foo: { bar: [123] } });
            test.done();
        },
        'fails if a field is not an array'(test) {
            test.throws(() => util_1.mergeEventPattern(undefined, 123), /Invalid event pattern '123', expecting an object or an array/);
            test.throws(() => util_1.mergeEventPattern(undefined, 'Hello'), /Invalid event pattern '"Hello"', expecting an object or an array/);
            test.throws(() => util_1.mergeEventPattern(undefined, { foo: '123' }), /Invalid event pattern field { foo: "123" }. All fields must be arrays/);
            test.done();
        },
        'fails if mismatch between dest and src'(test) {
            test.throws(() => util_1.mergeEventPattern({
                obj: {
                    array: [1],
                },
            }, {
                obj: {
                    array: {
                        value: ['hello'],
                    },
                },
            }), /Invalid event pattern field array. Type mismatch between existing pattern \[1\] and added pattern \{"value":\["hello"\]\}/);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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