# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesNodePoolArgs', 'KubernetesNodePool']

@pulumi.input_type
class KubernetesNodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 node_type: pulumi.Input[str],
                 size: pulumi.Input[int],
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input['KubernetesNodePoolUpgradePolicyArgs']] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KubernetesNodePool resource.
        :param pulumi.Input[str] cluster_id: The ID of the cluster on which this pool will be created
        :param pulumi.Input[str] node_type: Server type of the pool servers
        :param pulumi.Input[int] size: Size of the pool
        :param pulumi.Input[bool] autohealing: Enable the autohealing on the pool
        :param pulumi.Input[bool] autoscaling: Enable the autoscaling on the pool
        :param pulumi.Input[str] container_runtime: Container runtime for the pool
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: Maximum size of the pool
        :param pulumi.Input[int] min_size: Minimun size of the pool
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[str] placement_group_id: ID of the placement group
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool
        :param pulumi.Input['KubernetesNodePoolUpgradePolicyArgs'] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "size", size)
        if autohealing is not None:
            pulumi.set(__self__, "autohealing", autohealing)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if container_runtime is not None:
            pulumi.set(__self__, "container_runtime", container_runtime)
        if kubelet_args is not None:
            pulumi.set(__self__, "kubelet_args", kubelet_args)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if wait_for_pool_ready is not None:
            pulumi.set(__self__, "wait_for_pool_ready", wait_for_pool_ready)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the cluster on which this pool will be created
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        Server type of the pool servers
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Size of the pool
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def autohealing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the autohealing on the pool
        """
        return pulumi.get(self, "autohealing")

    @autohealing.setter
    def autohealing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autohealing", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the autoscaling on the pool
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="containerRuntime")
    def container_runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Container runtime for the pool
        """
        return pulumi.get(self, "container_runtime")

    @container_runtime.setter
    def container_runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_runtime", value)

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Kubelet arguments to be used by this pool
        """
        return pulumi.get(self, "kubelet_args")

    @kubelet_args.setter
    def kubelet_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "kubelet_args", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of the pool
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimun size of the pool
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the placement group
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the pool
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['KubernetesNodePoolUpgradePolicyArgs']]:
        """
        The Pool upgrade policy
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['KubernetesNodePoolUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @property
    @pulumi.getter(name="waitForPoolReady")
    def wait_for_pool_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to wait for the pool to be ready
        """
        return pulumi.get(self, "wait_for_pool_ready")

    @wait_for_pool_ready.setter
    def wait_for_pool_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_pool_ready", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _KubernetesNodePoolState:
    def __init__(__self__, *,
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 current_size: Optional[pulumi.Input[int]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolNodeArgs']]]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 upgrade_policy: Optional[pulumi.Input['KubernetesNodePoolUpgradePolicyArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KubernetesNodePool resources.
        :param pulumi.Input[bool] autohealing: Enable the autohealing on the pool
        :param pulumi.Input[bool] autoscaling: Enable the autoscaling on the pool
        :param pulumi.Input[str] cluster_id: The ID of the cluster on which this pool will be created
        :param pulumi.Input[str] container_runtime: Container runtime for the pool
        :param pulumi.Input[str] created_at: The date and time of the creation of the pool
        :param pulumi.Input[int] current_size: The actual size of the pool
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: Maximum size of the pool
        :param pulumi.Input[int] min_size: Minimun size of the pool
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[str] node_type: Server type of the pool servers
        :param pulumi.Input[str] placement_group_id: ID of the placement group
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input[int] size: Size of the pool
        :param pulumi.Input[str] status: The status of the pool
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool
        :param pulumi.Input[str] updated_at: The date and time of the last update of the pool
        :param pulumi.Input['KubernetesNodePoolUpgradePolicyArgs'] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[str] version: The Kubernetes version of the pool
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        if autohealing is not None:
            pulumi.set(__self__, "autohealing", autohealing)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if container_runtime is not None:
            pulumi.set(__self__, "container_runtime", container_runtime)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if current_size is not None:
            pulumi.set(__self__, "current_size", current_size)
        if kubelet_args is not None:
            pulumi.set(__self__, "kubelet_args", kubelet_args)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_for_pool_ready is not None:
            pulumi.set(__self__, "wait_for_pool_ready", wait_for_pool_ready)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def autohealing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the autohealing on the pool
        """
        return pulumi.get(self, "autohealing")

    @autohealing.setter
    def autohealing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autohealing", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the autoscaling on the pool
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cluster on which this pool will be created
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="containerRuntime")
    def container_runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Container runtime for the pool
        """
        return pulumi.get(self, "container_runtime")

    @container_runtime.setter
    def container_runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_runtime", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the creation of the pool
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="currentSize")
    def current_size(self) -> Optional[pulumi.Input[int]]:
        """
        The actual size of the pool
        """
        return pulumi.get(self, "current_size")

    @current_size.setter
    def current_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_size", value)

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Kubelet arguments to be used by this pool
        """
        return pulumi.get(self, "kubelet_args")

    @kubelet_args.setter
    def kubelet_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "kubelet_args", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of the pool
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimun size of the pool
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        Server type of the pool servers
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolNodeArgs']]]]:
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the placement group
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the pool
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the pool
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the pool
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the last update of the pool
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['KubernetesNodePoolUpgradePolicyArgs']]:
        """
        The Pool upgrade policy
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['KubernetesNodePoolUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Kubernetes version of the pool
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitForPoolReady")
    def wait_for_pool_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to wait for the pool to be ready
        """
        return pulumi.get(self, "wait_for_pool_ready")

    @wait_for_pool_ready.setter
    def wait_for_pool_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_pool_ready", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class KubernetesNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[pulumi.InputType['KubernetesNodePoolUpgradePolicyArgs']]] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a KubernetesNodePool resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autohealing: Enable the autohealing on the pool
        :param pulumi.Input[bool] autoscaling: Enable the autoscaling on the pool
        :param pulumi.Input[str] cluster_id: The ID of the cluster on which this pool will be created
        :param pulumi.Input[str] container_runtime: Container runtime for the pool
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: Maximum size of the pool
        :param pulumi.Input[int] min_size: Minimun size of the pool
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[str] node_type: Server type of the pool servers
        :param pulumi.Input[str] placement_group_id: ID of the placement group
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input[int] size: Size of the pool
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool
        :param pulumi.Input[pulumi.InputType['KubernetesNodePoolUpgradePolicyArgs']] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a KubernetesNodePool resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param KubernetesNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[pulumi.InputType['KubernetesNodePoolUpgradePolicyArgs']]] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesNodePoolArgs.__new__(KubernetesNodePoolArgs)

            __props__.__dict__["autohealing"] = autohealing
            __props__.__dict__["autoscaling"] = autoscaling
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["container_runtime"] = container_runtime
            __props__.__dict__["kubelet_args"] = kubelet_args
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["placement_group_id"] = placement_group_id
            __props__.__dict__["region"] = region
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upgrade_policy"] = upgrade_policy
            __props__.__dict__["wait_for_pool_ready"] = wait_for_pool_ready
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["current_size"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["version"] = None
        super(KubernetesNodePool, __self__).__init__(
            'scaleway:index/kubernetesNodePool:KubernetesNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autohealing: Optional[pulumi.Input[bool]] = None,
            autoscaling: Optional[pulumi.Input[bool]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            container_runtime: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            current_size: Optional[pulumi.Input[int]] = None,
            kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            max_size: Optional[pulumi.Input[int]] = None,
            min_size: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesNodePoolNodeArgs']]]]] = None,
            placement_group_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            upgrade_policy: Optional[pulumi.Input[pulumi.InputType['KubernetesNodePoolUpgradePolicyArgs']]] = None,
            version: Optional[pulumi.Input[str]] = None,
            wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'KubernetesNodePool':
        """
        Get an existing KubernetesNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autohealing: Enable the autohealing on the pool
        :param pulumi.Input[bool] autoscaling: Enable the autoscaling on the pool
        :param pulumi.Input[str] cluster_id: The ID of the cluster on which this pool will be created
        :param pulumi.Input[str] container_runtime: Container runtime for the pool
        :param pulumi.Input[str] created_at: The date and time of the creation of the pool
        :param pulumi.Input[int] current_size: The actual size of the pool
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: Maximum size of the pool
        :param pulumi.Input[int] min_size: Minimun size of the pool
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[str] node_type: Server type of the pool servers
        :param pulumi.Input[str] placement_group_id: ID of the placement group
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input[int] size: Size of the pool
        :param pulumi.Input[str] status: The status of the pool
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool
        :param pulumi.Input[str] updated_at: The date and time of the last update of the pool
        :param pulumi.Input[pulumi.InputType['KubernetesNodePoolUpgradePolicyArgs']] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[str] version: The Kubernetes version of the pool
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesNodePoolState.__new__(_KubernetesNodePoolState)

        __props__.__dict__["autohealing"] = autohealing
        __props__.__dict__["autoscaling"] = autoscaling
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["container_runtime"] = container_runtime
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["current_size"] = current_size
        __props__.__dict__["kubelet_args"] = kubelet_args
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["placement_group_id"] = placement_group_id
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["upgrade_policy"] = upgrade_policy
        __props__.__dict__["version"] = version
        __props__.__dict__["wait_for_pool_ready"] = wait_for_pool_ready
        __props__.__dict__["zone"] = zone
        return KubernetesNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def autohealing(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable the autohealing on the pool
        """
        return pulumi.get(self, "autohealing")

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable the autoscaling on the pool
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the cluster on which this pool will be created
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="containerRuntime")
    def container_runtime(self) -> pulumi.Output[Optional[str]]:
        """
        Container runtime for the pool
        """
        return pulumi.get(self, "container_runtime")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of the creation of the pool
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="currentSize")
    def current_size(self) -> pulumi.Output[int]:
        """
        The actual size of the pool
        """
        return pulumi.get(self, "current_size")

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The Kubelet arguments to be used by this pool
        """
        return pulumi.get(self, "kubelet_args")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[int]:
        """
        Maximum size of the pool
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[Optional[int]]:
        """
        Minimun size of the pool
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cluster
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        Server type of the pool servers
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.KubernetesNodePoolNode']]:
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the placement group
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Size of the pool
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the pool
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the pool
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date and time of the last update of the pool
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> pulumi.Output['outputs.KubernetesNodePoolUpgradePolicy']:
        """
        The Pool upgrade policy
        """
        return pulumi.get(self, "upgrade_policy")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The Kubernetes version of the pool
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="waitForPoolReady")
    def wait_for_pool_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to wait for the pool to be ready
        """
        return pulumi.get(self, "wait_for_pool_ready")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

